/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.login.strategy;

import com.bxm.component.bus.config.ComponentEventBus;
import com.bxm.egg.user.constant.UserLoginTypeEnum;
import com.bxm.egg.user.constant.UserStateEnum;
import com.bxm.egg.user.info.UserInfoCacheService;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.login.UserLogService;
import com.bxm.egg.user.login.event.LoginEvent;
import com.bxm.egg.user.login.strategy.IUserLoginStrategy;
import com.bxm.egg.user.mapper.UserInfoMapper;
import com.bxm.egg.user.model.dto.login.LoginResultDTO;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.param.login.LoginParam;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.param.BasicParam;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUserLoginStrategy<T extends LoginParam>
implements IUserLoginStrategy<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractUserLoginStrategy.class);
    public static final String LOGIN_RESULT_DTO = "loginResultDTO";
    @Resource
    private DistributedLock distributedLock;
    @Resource
    private UserInfoCacheService userInfoCacheService;
    @Resource
    private UserInfoService userInfoService;
    @Resource
    private UserLogService userLogService;
    @Resource
    private UserInfoMapper userInfoMapper;
    @Resource
    private UserProperties userProperties;
    @Resource
    private SequenceCreater sequenceCreater;

    protected void preConditon(T loginParam) {
    }

    protected void afterLogin(LoginResultDTO resultDTO, T loginParam) {
    }

    protected abstract Long checkExists(T var1);

    public abstract UserLoginTypeEnum type();

    protected abstract boolean saveIdentity(T var1, Long var2);

    protected abstract void fillUserInfo(T var1, UserInfoEntity var2);

    @Override
    public Message doLogin(T loginParam) {
        LoginResultDTO resultDTO;
        String resource = loginParam.hashCode() + "";
        if (!this.distributedLock.lock(resource)) {
            log.info("\u51fa\u73b0\u91cd\u590d\u70b9\u51fb\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(loginParam));
            return null;
        }
        Message beforeAuthenticationResult = this.beforeLoginAuthentication(loginParam);
        if (!beforeAuthenticationResult.isSuccess()) {
            return beforeAuthenticationResult;
        }
        this.preConditon(loginParam);
        Long userId = this.checkExists(loginParam);
        if (null != userId) {
            Message handleExistsUserMsg = this.handleExistsUser(userId, loginParam);
            if (!handleExistsUserMsg.isSuccess()) {
                return handleExistsUserMsg;
            }
            resultDTO = (LoginResultDTO)handleExistsUserMsg.getParam(LOGIN_RESULT_DTO);
        } else {
            Message handleNewUserMsg = this.handleNewUser(loginParam);
            if (!handleNewUserMsg.isSuccess()) {
                return handleNewUserMsg;
            }
            resultDTO = (LoginResultDTO)handleNewUserMsg.getParam(LOGIN_RESULT_DTO);
        }
        if (null == resultDTO) {
            return Message.build((boolean)false, (String)"\u60a8\u7684\u8d26\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        Message afterAuthenticationResult = this.afterLoginAuthentication(loginParam, resultDTO);
        if (!afterAuthenticationResult.isSuccess()) {
            return afterAuthenticationResult;
        }
        this.publishLoginEvent(loginParam, resultDTO);
        this.distributedLock.unlock(resource);
        this.afterLogin(resultDTO, loginParam);
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)resultDTO));
        }
        this.userLogService.recordLoginLog((LoginParam)loginParam, resultDTO, this.type());
        Message resultMsg = Message.build((boolean)true);
        resultMsg.addParam(LOGIN_RESULT_DTO, (Object)resultDTO);
        return resultMsg;
    }

    protected Message beforeLoginAuthentication(T loginParam) {
        return Message.build((boolean)true);
    }

    protected Message afterLoginAuthentication(T loginParam, LoginResultDTO resultDTO) {
        return Message.build((boolean)true);
    }

    protected Message handleNewUser(T loginParam) {
        Long userId = this.userInfoService.generateUserId((BasicParam)loginParam);
        UserInfoEntity newUser = new UserInfoEntity();
        newUser.setId(userId);
        newUser.setEquipmentId(loginParam.getDevcId());
        newUser.setCreateTime(new Date());
        newUser.setState(Integer.valueOf(UserStateEnum.NORMAL.getCode()));
        newUser.setLastLoginTime(new Date());
        newUser.setSalt(RandomUtils.getRandomStr((int)6, (boolean)true));
        this.fillUserInfo(loginParam, newUser);
        if (null == newUser.getHeadImg()) {
            newUser.setHeadImg(this.userProperties.getDefaultHeadImagUrl());
        }
        if (this.saveIdentity(loginParam, userId)) {
            this.userInfoMapper.insert((Object)newUser);
            this.userInfoService.initUserExtendData(newUser);
            this.userLogService.recordRegisterLog(newUser, (LoginParam)loginParam);
        }
        Message message = Message.build((boolean)true);
        return message.addParam(LOGIN_RESULT_DTO, (Object)LoginResultDTO.builder().firstLogin(Boolean.valueOf(true)).userId(userId).nickName(newUser.getNickname()).headImg(newUser.getHeadImg()).build());
    }

    protected Message handleExistsUser(Long userId, T loginParam) {
        UserInfoEntity cacheInfo = this.userInfoService.selectUserById(userId);
        LoginResultDTO resultDTO = LoginResultDTO.builder().firstLogin(Boolean.valueOf(false)).userId(cacheInfo.getId()).headImg(cacheInfo.getHeadImg()).nickName(cacheInfo.getNickname()).build();
        if (UserStateEnum.NOT_ACTIVATED.equalsCode(cacheInfo.getState())) {
            this.userInfoService.updateStatus(userId, UserStateEnum.NORMAL);
            resultDTO.setFirstLogin(Boolean.valueOf(true));
        } else {
            if (UserStateEnum.BLACK.equalsCode(cacheInfo.getState())) {
                log.info("\u5c4f\u853d\u7684\u7528\u6237[{}]\u5c1d\u8bd5\u767b\u5f55\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)userId, JSON.toJSON(loginParam));
                return Message.build((boolean)false, (String)"\u767b\u5f55\u4e2d\uff0c\u8bf7\u7a0d\u540e");
            }
            if (!UserStateEnum.NORMAL.equalsCode(cacheInfo.getState())) {
                log.info("\u7528\u6237\u72b6\u6001[{}]\u4e0d\u5339\u914d\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)cacheInfo.getState(), JSON.toJSON(loginParam));
                return Message.build((boolean)false, (String)"\u767b\u5f55\u4e2d\uff0c\u8bf7\u7a0d\u540e");
            }
        }
        Message message = Message.build((boolean)true);
        message.addParam(LOGIN_RESULT_DTO, (Object)resultDTO);
        return message;
    }

    private void publishLoginEvent(T loginParam, LoginResultDTO loginResult) {
        LoginEvent<T> event = new LoginEvent<T>();
        event.setLoginParam(loginParam);
        event.setFirstLogin(loginResult.getFirstLogin());
        event.setUserId(loginResult.getUserId());
        event.setNickName(loginResult.getNickName());
        event.setHeadImg(loginResult.getHeadImg());
        event.setLoginType(this.type());
        ComponentEventBus.publishInnerEvent(event);
    }
}

