/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.login.strategy.support;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.user.constant.UserLoginTypeEnum;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.login.strategy.AbstractUserLoginStrategy;
import com.bxm.egg.user.model.dto.login.LoginResultDTO;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.param.WechatBindMobileOneKeyLoginParam;
import com.bxm.egg.user.onekey.OneKeyService;
import com.bxm.newidea.component.bo.Message;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OneKeyBindMobileLoginStrategy
extends AbstractUserLoginStrategy<WechatBindMobileOneKeyLoginParam> {
    private static final Logger log = LoggerFactory.getLogger(OneKeyBindMobileLoginStrategy.class);
    @Resource
    private UserInfoService userInfoService;
    @Resource
    private OneKeyService oneKeyService;

    @Override
    protected Message beforeLoginAuthentication(WechatBindMobileOneKeyLoginParam loginParam) {
        Message message = this.oneKeyService.checkToken(loginParam.getToken());
        if (!message.isSuccess()) {
            return Message.build((boolean)false, (String)"\u4e00\u952e\u767b\u5f55\u7ed1\u5b9a\u5931\u8d25");
        }
        String phone = (String)message.getParam("phone");
        loginParam.setPhone(phone);
        Optional<Long> userUnionIdExist = this.userInfoService.userUnionIdExist(loginParam.getUnionId());
        if (!userUnionIdExist.isPresent()) {
            return Message.build((boolean)false, (String)"\u5fae\u4fe1\u7528\u6237\u672a\u6388\u6743");
        }
        Optional<Long> userPhoneExist = this.userInfoService.userPhoneExist(loginParam.getPhone());
        if (userPhoneExist.isPresent() && !Objects.equals(userPhoneExist.get(), userUnionIdExist.get())) {
            return Message.build((boolean)false, (String)"\u5f53\u524d\u624b\u673a\u53f7\u5df2\u7ecf\u88ab\u7ed1\u5b9a");
        }
        return Message.build((boolean)true);
    }

    @Override
    protected Long checkExists(WechatBindMobileOneKeyLoginParam loginParam) {
        Optional<Long> userUnionIdExistOptional = this.userInfoService.userUnionIdExist(loginParam.getUnionId());
        if (!userUnionIdExistOptional.isPresent()) {
            log.error("\u6388\u6743\u7ed1\u5b9a\u7684\u7528\u6237\u4e0d\u5b58\u5728\uff0c \u7528\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)loginParam));
            return null;
        }
        loginParam.setUserId(userUnionIdExistOptional.get());
        return userUnionIdExistOptional.get();
    }

    @Override
    public UserLoginTypeEnum type() {
        return UserLoginTypeEnum.WECHAT_BIND_MOBILE_ONE_KEY_LOGIN;
    }

    @Override
    protected boolean saveIdentity(WechatBindMobileOneKeyLoginParam loginParam, Long userId) {
        return true;
    }

    @Override
    protected void fillUserInfo(WechatBindMobileOneKeyLoginParam loginParam, UserInfoEntity newUser) {
    }

    @Override
    protected void afterLogin(LoginResultDTO resultDTO, WechatBindMobileOneKeyLoginParam loginParam) {
        this.userInfoService.bindPhone(resultDTO.getUserId(), loginParam.getPhone());
        this.userInfoService.bindUsername(resultDTO.getUserId(), loginParam.getPhone());
    }
}

