/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.login.strategy.support;

import com.bxm.egg.user.constant.UserLoginTypeEnum;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.login.strategy.AbstractUserLoginStrategy;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.param.login.ChuangLanLoginParam;
import com.bxm.egg.user.onekey.OneKeyService;
import com.bxm.newidea.component.bo.Message;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OneKeyLoginStrategy
extends AbstractUserLoginStrategy<ChuangLanLoginParam> {
    private static final Logger log = LoggerFactory.getLogger(OneKeyLoginStrategy.class);
    @Resource
    private UserInfoService userInfoService;
    @Resource
    private OneKeyService oneKeyService;

    @Override
    protected Message beforeLoginAuthentication(ChuangLanLoginParam loginParam) {
        Message message = this.oneKeyService.checkToken(loginParam.getToken());
        if (!message.isSuccess()) {
            return message;
        }
        String phone = (String)message.getParam("phone");
        loginParam.setPhone(phone);
        return Message.build((boolean)true);
    }

    @Override
    protected Long checkExists(ChuangLanLoginParam loginParam) {
        Optional<Long> userUnionIdExistOptional = this.userInfoService.userPhoneExist(loginParam.getPhone());
        return userUnionIdExistOptional.orElse(null);
    }

    @Override
    public UserLoginTypeEnum type() {
        return UserLoginTypeEnum.ONE_KEY;
    }

    @Override
    protected boolean saveIdentity(ChuangLanLoginParam loginParam, Long userId) {
        return true;
    }

    @Override
    protected void fillUserInfo(ChuangLanLoginParam loginParam, UserInfoEntity newUser) {
        newUser.setPhone(loginParam.getPhone());
        newUser.setUsername(loginParam.getPhone());
    }
}

