/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.login.strategy.support;

import com.bxm.egg.user.constant.UserLoginTypeEnum;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.integration.SmsIntegrationService;
import com.bxm.egg.user.login.strategy.AbstractUserLoginStrategy;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.param.login.PhoneAppLoginParam;
import com.bxm.newidea.component.bo.Message;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SmsLoginStrategy
extends AbstractUserLoginStrategy<PhoneAppLoginParam> {
    private static final Logger log = LoggerFactory.getLogger(SmsLoginStrategy.class);
    @Resource
    private SmsIntegrationService smsIntegrationService;
    @Resource
    private UserInfoService userInfoService;

    @Override
    protected Message beforeLoginAuthentication(PhoneAppLoginParam loginParam) {
        if (!this.smsIntegrationService.verifyByType(Byte.valueOf((byte)1), loginParam.getPhone(), loginParam.getSmsCode()).booleanValue()) {
            return Message.build((boolean)false, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        return Message.build((boolean)true);
    }

    @Override
    protected Long checkExists(PhoneAppLoginParam loginParam) {
        Optional<Long> userPhoneExistOptional = this.userInfoService.userPhoneExist(loginParam.getPhone());
        return userPhoneExistOptional.orElse(null);
    }

    @Override
    public UserLoginTypeEnum type() {
        return UserLoginTypeEnum.SMS;
    }

    @Override
    protected boolean saveIdentity(PhoneAppLoginParam loginParam, Long userId) {
        return true;
    }

    @Override
    protected void fillUserInfo(PhoneAppLoginParam loginParam, UserInfoEntity newUser) {
        newUser.setPhone(loginParam.getPhone());
        newUser.setUsername(loginParam.getPhone());
    }
}

