/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.login.strategy.support;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.user.constant.UserLoginTypeEnum;
import com.bxm.egg.user.info.UserExtendService;
import com.bxm.egg.user.info.UserInfoCacheService;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.login.strategy.AbstractUserLoginStrategy;
import com.bxm.egg.user.mapper.UserGrantWechatAppMapper;
import com.bxm.egg.user.model.dto.login.LoginResultDTO;
import com.bxm.egg.user.model.entity.UserGrantWechatAppEntity;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.param.login.WechatAppLoginParam;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.param.BasicParam;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import java.util.Date;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class WechatLoginStrategy
extends AbstractUserLoginStrategy<WechatAppLoginParam> {
    private static final Logger log = LoggerFactory.getLogger(WechatLoginStrategy.class);
    @Resource
    private UserGrantWechatAppMapper userGrantWechatAppMapper;
    @Resource
    private UserExtendService userExtendService;
    @Resource
    private UserInfoService userInfoService;
    @Resource
    private UserInfoCacheService userInfoCacheService;

    @Override
    protected Long checkExists(WechatAppLoginParam loginParam) {
        Optional<Long> userUnionIdExistOptional = this.userInfoService.userUnionIdExist(loginParam.getUnionId());
        return userUnionIdExistOptional.orElse(null);
    }

    @Override
    protected Message afterLoginAuthentication(WechatAppLoginParam loginParam, LoginResultDTO resultDTO) {
        UserInfoEntity userInfoEntity = this.userInfoService.selectUserById(resultDTO.getUserId());
        if (StringUtils.isEmpty((Object)userInfoEntity.getPhone())) {
            log.warn("\u7528\u6237\u5df2\u7ecf\u7ed1\u5b9a\u5fae\u4fe1\uff0c\u672a\u7ed1\u5b9a\u624b\u673a\uff0c\u7ed1\u5b9a\u624b\u673a\u540e\u624d\u80fd\u7ee7\u7eed\u767b\u5f55,\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)resultDTO));
            Message resultMessage = Message.build((boolean)false, (String)"\u60a8\u9700\u8981\u7ed1\u5b9a\u624b\u673a\u53f7");
            resultMessage.setBizCode("10001");
            return resultMessage;
        }
        return Message.build((boolean)true);
    }

    @Override
    public UserLoginTypeEnum type() {
        return UserLoginTypeEnum.WX;
    }

    @Override
    protected boolean saveIdentity(WechatAppLoginParam loginParam, Long userId) {
        UserGrantWechatAppEntity entity = new UserGrantWechatAppEntity();
        entity.setId(SequenceHolder.nextLongId());
        entity.setCountry(loginParam.getCountry());
        entity.setProvince(loginParam.getProvince());
        entity.setCity(loginParam.getCity());
        entity.setNickName(loginParam.getNickName());
        entity.setHeadImg(loginParam.getHeadImageUrl());
        entity.setOpenId(loginParam.getOpenId());
        entity.setUnionId(loginParam.getUnionId());
        entity.setSex(loginParam.getSex());
        entity.setUserId(userId);
        entity.setCreateTime(new Date());
        return this.userGrantWechatAppMapper.insert((Object)entity) > 0;
    }

    @Override
    protected void fillUserInfo(WechatAppLoginParam loginParam, UserInfoEntity newUser) {
        String newHeadImg = this.userExtendService.uploadWechatImage(loginParam.getHeadImageUrl(), (BasicParam)loginParam, newUser.getId());
        newUser.setHeadImg(newHeadImg);
        newUser.setNickname(loginParam.getNickName());
        newUser.setSex(loginParam.getSex());
    }
}

