/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.medal.cache;

import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.model.dto.medal.UserGrantMedalDTO;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserMedalPopCacheManager {
    private static final Logger log = LoggerFactory.getLogger(UserMedalPopCacheManager.class);
    private RedisListAdapter redisListAdapter;

    public void addUserMedalPopCache(Long userId, UserGrantMedalDTO userGrantMedalDTO) {
        this.redisListAdapter.leftPush(this.buildUserMedalPopKey(userId), new Object[]{userGrantMedalDTO});
    }

    public UserGrantMedalDTO getUserMedalPopCache(Long userId) {
        return (UserGrantMedalDTO)this.redisListAdapter.rightPop(this.buildUserMedalPopKey(userId), UserGrantMedalDTO.class);
    }

    private KeyGenerator buildUserMedalPopKey(Long userId) {
        return RedisConfig.USER_POP_MEDAL_DATA.copy().appendKey((Object)userId);
    }

    public UserMedalPopCacheManager(RedisListAdapter redisListAdapter) {
        this.redisListAdapter = redisListAdapter;
    }
}

