/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.medal.impl;

import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.mapper.medal.UserMedalRelationInfoMapper;
import com.bxm.egg.user.medal.UserMedalManageService;
import com.bxm.egg.user.medal.UserMedalService;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.vo.medal.manage.CustomMedalVO;
import com.bxm.egg.user.model.vo.medal.manage.UserMedalInfoVO;
import com.bxm.newidea.component.tools.DateUtils;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserMedalManageServiceImpl
implements UserMedalManageService {
    private static final Logger log = LoggerFactory.getLogger(UserMedalManageServiceImpl.class);
    private final UserMedalRelationInfoMapper userMedalRelationInfoMapper;
    private final UserInfoService userInfoService;
    private final UserMedalService userMedalService;

    @Override
    public UserMedalInfoVO getUserMedalInfo(Long userId) {
        UserMedalInfoVO resultVO = new UserMedalInfoVO();
        UserInfoEntity currentUserInfo = this.userInfoService.selectUserById(userId);
        resultVO.setUserId(userId);
        resultVO.setPhone(currentUserInfo.getPhone());
        resultVO.setNickname(currentUserInfo.getNickname());
        resultVO.setMedalNum(Integer.valueOf(this.userMedalService.getUserMedalNum(userId)));
        resultVO.setAchievementMedalList(this.userMedalRelationInfoMapper.getUserAchievementMedalList(userId));
        List userCustomMedalList = this.userMedalRelationInfoMapper.getUserCustomMedalList(userId);
        for (CustomMedalVO customMedalVO : userCustomMedalList) {
            String grantTimeStr = DateUtils.formatDateTime((Date)customMedalVO.getGrantTime());
            String expiredTimeStr = DateUtils.formatDateTime((Date)customMedalVO.getExpiredTime());
            customMedalVO.setEffectiveRange(grantTimeStr + "-" + expiredTimeStr);
        }
        resultVO.setCustomMedalList(userCustomMedalList);
        return resultVO;
    }

    public UserMedalManageServiceImpl(UserMedalRelationInfoMapper userMedalRelationInfoMapper, UserInfoService userInfoService, UserMedalService userMedalService) {
        this.userMedalRelationInfoMapper = userMedalRelationInfoMapper;
        this.userInfoService = userInfoService;
        this.userMedalService = userMedalService;
    }
}

