/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.medal.strategy;

import com.bxm.egg.user.medal.strategy.AbstractMedalCounterStrategy;
import com.bxm.egg.user.model.dto.medal.UserMedalCounterDTO;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MedalCounterStrategyManager {
    private static final Logger log = LoggerFactory.getLogger(MedalCounterStrategyManager.class);
    private List<AbstractMedalCounterStrategy> medalCounterStrategyList;

    public void handleCounterData(UserMedalCounterDTO userMedalCounterDTO) {
        AbstractMedalCounterStrategy targetStrategy = this.matchStrategy(userMedalCounterDTO);
        if (Objects.nonNull(targetStrategy)) {
            targetStrategy.handleData(userMedalCounterDTO);
        }
    }

    private AbstractMedalCounterStrategy matchStrategy(UserMedalCounterDTO userMedalCounterDTO) {
        for (AbstractMedalCounterStrategy medalCounterStrategy : this.medalCounterStrategyList) {
            if (!medalCounterStrategy.counterType().equals(userMedalCounterDTO.getOperatorType())) continue;
            return medalCounterStrategy;
        }
        log.error("\u672a\u5339\u914d\u5230\u52cb\u7ae0\u7edf\u8ba1\u6570\u636e\u5904\u7406\u7b56\u7565");
        return null;
    }

    public MedalCounterStrategyManager(List<AbstractMedalCounterStrategy> medalCounterStrategyList) {
        this.medalCounterStrategyList = medalCounterStrategyList;
    }
}

