/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.support.impl;

import com.bxm.egg.user.attribute.UserFollowService;
import com.bxm.egg.user.attribute.UserTagService;
import com.bxm.egg.user.attribute.UserVisitService;
import com.bxm.egg.user.constant.DomainScene;
import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.enums.WarmValueEquityEnum;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.info.UserInformationService;
import com.bxm.egg.user.info.UserStatisticsService;
import com.bxm.egg.user.integration.DomainIntegrationService;
import com.bxm.egg.user.integration.PushMsgIntegrationService;
import com.bxm.egg.user.location.UserLocationService;
import com.bxm.egg.user.login.UserService;
import com.bxm.egg.user.mapper.UserLoginHistoryMapper;
import com.bxm.egg.user.medal.UserMedalService;
import com.bxm.egg.user.model.UserEquityDTO;
import com.bxm.egg.user.model.dto.BaseHomePage;
import com.bxm.egg.user.model.dto.CustomerHomePageDTO;
import com.bxm.egg.user.model.dto.LocationUserInfoDTO;
import com.bxm.egg.user.model.dto.OneselfHomePageDTO;
import com.bxm.egg.user.model.dto.UserCoverDTO;
import com.bxm.egg.user.model.dto.warmlevel.OneselfHomePageCoverDTO;
import com.bxm.egg.user.model.dto.warmlevel.UserWarmLevelInfoDTO;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.entity.UserInformationEntity;
import com.bxm.egg.user.model.entity.UserLocationEntity;
import com.bxm.egg.user.model.entity.UserStatisticsEntity;
import com.bxm.egg.user.model.vo.UserTag;
import com.bxm.egg.user.properties.HomePageConfigProperties;
import com.bxm.egg.user.properties.NativeUserProperties;
import com.bxm.egg.user.support.HomePageService;
import com.bxm.egg.user.utils.ConstellationUtils;
import com.bxm.egg.user.warmlevel.UserWarmLevelService;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HomePageServiceImpl
implements HomePageService {
    private static final Logger log = LoggerFactory.getLogger(HomePageServiceImpl.class);
    private final String RESOURCE = "homepage:systemmessage:lock:";
    private final HomePageConfigProperties homePageConfigProperties;
    private final RedisStringAdapter redisStringAdapter;
    private final UserLoginHistoryMapper userLoginHistoryMapper;
    private final PushMsgIntegrationService pushMsgIntegrationService;
    private final DistributedLock distributedLock;
    private final UserTagService userTagService;
    private final UserVisitService userVisitService;
    private final NativeUserProperties nativeUserProperties;
    private final UserService userService;
    private final DomainIntegrationService domainIntegrationService;
    private final UserWarmLevelService userWarmLevelService;
    private final UserMedalService userMedalService;
    private final UserInfoService userInfoService;
    private final UserInformationService userInformationService;
    private final UserStatisticsService userStatisticsService;
    private final UserLocationService userLocationService;

    @Override
    public OneselfHomePageDTO getOneselfHomePage(Long userId) {
        OneselfHomePageDTO result = new OneselfHomePageDTO();
        BaseHomePage baseHomePage = this.getBaseHomePage(userId, userId);
        BeanUtils.copyProperties((Object)baseHomePage, (Object)result);
        result.setInterviewHeadImgs(this.userVisitService.listRecentVisitorHeadImg(userId));
        result.setTodayInterviewNum(this.userVisitService.getTodayVisitorNum(userId));
        result.setAllInterviewNum(this.userVisitService.getInterviewNumByUserId(userId));
        result.setMedalMainPageSimpleDTO(this.userMedalService.getMainPageMedalDetail(userId));
        result.setCoverDTO(this.builderUserCoverInfo(userId, result));
        return result;
    }

    private OneselfHomePageCoverDTO builderUserCoverInfo(Long userId, OneselfHomePageDTO result) {
        OneselfHomePageCoverDTO oneselfHomePageCoverDTO = new OneselfHomePageCoverDTO();
        UserEquityDTO userWarmLevelDTO = result.getUserWarmLevelDTO();
        String[] equityType = userWarmLevelDTO.getEquityType();
        List<String> equityList = Collections.EMPTY_LIST;
        if (equityType != null) {
            equityList = Arrays.asList(equityType);
        }
        if (equityList.contains(WarmValueEquityEnum.USER_COVER.name())) {
            oneselfHomePageCoverDTO.setCustomMadeCoverLevel(Boolean.valueOf(true));
            UserCoverDTO userCoverDTO = (UserCoverDTO)this.redisStringAdapter.get(this.userCoverCache(userId), UserCoverDTO.class);
            oneselfHomePageCoverDTO.setShowCustomMadeCover(Boolean.valueOf(Objects.isNull(userCoverDTO)));
            return oneselfHomePageCoverDTO;
        }
        oneselfHomePageCoverDTO.setCustomMadeCoverLevel(Boolean.valueOf(false));
        return oneselfHomePageCoverDTO;
    }

    @Override
    public CustomerHomePageDTO getCustomerHomePage(Long targetUserId, Long userId) {
        CustomerHomePageDTO result = new CustomerHomePageDTO();
        BaseHomePage baseHomePage = this.getBaseHomePage(userId, targetUserId);
        BeanUtils.copyProperties((Object)baseHomePage, (Object)result);
        result.setIsAttention(((UserFollowService)SpringContextHolder.getBean(UserFollowService.class)).isFollowed(userId, targetUserId));
        this.userVisitService.visit(userId, targetUserId);
        result.setMedalMainPageSimpleDTO(this.userMedalService.getMainPageMedalDetail(targetUserId));
        return result;
    }

    private BaseHomePage getBaseHomePage(Long currUserId, Long targetUserId) {
        UserInfoEntity userInfoEntity = this.userInfoService.selectUserById(targetUserId);
        UserInformationEntity userInformationEntity = this.userInformationService.getUserInformationById(targetUserId);
        UserStatisticsEntity userStatisticsEntity = this.userStatisticsService.selectUserStatisticsByUserId(targetUserId);
        UserLocationEntity userLocationEntity = this.userLocationService.getUserLocationByUserId(targetUserId);
        BaseHomePage baseHomePage = new BaseHomePage();
        if (Objects.nonNull(userInfoEntity)) {
            BeanUtils.copyProperties((Object)userInfoEntity, (Object)baseHomePage);
            BeanUtils.copyProperties((Object)userInformationEntity, (Object)baseHomePage);
            BeanUtils.copyProperties((Object)userStatisticsEntity, (Object)baseHomePage);
            BeanUtils.copyProperties((Object)userLocationEntity, (Object)baseHomePage);
            baseHomePage.setId(targetUserId);
            if (Objects.equals(userInformationEntity.getIsDefaultPersonalProfile(), Boolean.TRUE)) {
                baseHomePage.setPersonalProfile(this.nativeUserProperties.getDefaultPersonalProfile());
            }
            if (null == userInformationEntity.getBirthday()) {
                baseHomePage.setAge(null);
            } else {
                LocalDate birthday = userInformationEntity.getBirthday().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                if (birthday.isAfter(LocalDate.now())) {
                    baseHomePage.setAge(null);
                } else {
                    baseHomePage.setConstellation(ConstellationUtils.calculateConstellation((LocalDate)birthday));
                    baseHomePage.setBirthday(birthday);
                    baseHomePage.setGeneration(this.getGeneration(birthday));
                    baseHomePage.setAge(Integer.valueOf(LocalDate.now().getYear() - birthday.getYear() + 1));
                }
            }
            String backgroundImg = null;
            UserCoverDTO userCoverDTO = (UserCoverDTO)this.redisStringAdapter.get(this.userCoverCache(targetUserId), UserCoverDTO.class);
            if (Objects.nonNull(userCoverDTO)) {
                backgroundImg = userCoverDTO.getAuditCover();
            }
            if (Objects.equals(currUserId, targetUserId) && Objects.nonNull(userCoverDTO) && StringUtils.isNotBlank((CharSequence)userCoverDTO.getNoAuditCover())) {
                backgroundImg = userCoverDTO.getNoAuditCover();
            }
            if (StringUtils.isBlank((CharSequence)backgroundImg)) {
                if (StringUtils.isBlank((CharSequence)baseHomePage.getBackgroundImgUrl())) {
                    List urls = this.homePageConfigProperties.getDefaultBackgroundImgUrls();
                    int index = ThreadLocalRandom.current().nextInt(this.homePageConfigProperties.getDefaultBackgroundImgUrls().size());
                    String backgroundImgUrl = (String)urls.get(index);
                    this.userInformationService.updateBackgroundImgUrlByUserId(targetUserId, backgroundImgUrl);
                    baseHomePage.setBackgroundImgUrl(backgroundImgUrl);
                }
            } else {
                baseHomePage.setBackgroundImgUrl(backgroundImg);
            }
            if (Objects.equals(userInformationEntity.getIsDefaultPersonalProfile(), Boolean.TRUE)) {
                baseHomePage.setShareSubTitle(this.homePageConfigProperties.getShareSubTitle());
            } else {
                baseHomePage.setShareSubTitle(baseHomePage.getPersonalProfile());
            }
            if (StringUtils.isNotBlank((CharSequence)this.homePageConfigProperties.getShareTitle()) && StringUtils.isNotBlank((CharSequence)userInfoEntity.getNickname())) {
                baseHomePage.setShareTitle(this.homePageConfigProperties.getShareTitle().replace("{nickName}", userInfoEntity.getNickname()));
            }
            String baseUrl = this.domainIntegrationService.getOutSideShareBaseUrl(DomainScene.DomainViewScene.CONTENT_VIEW);
            baseHomePage.setShareUrl(StringUtils.join((Object[])new String[]{baseUrl, "/shareUserHome.html"}));
            List<UserTag> userTagList = this.userTagService.getUserTagFromRedisDb(targetUserId);
            baseHomePage.setUserTagList(userTagList.stream().filter(e -> e.getDeleteFlag() == 0).map(UserTag::getLabel).collect(Collectors.toList()));
            UserWarmLevelInfoDTO userWarmInfoCache = this.userWarmLevelService.getUserWarmInfoCache(targetUserId);
            UserEquityDTO equityDTO = userWarmInfoCache.getEquityDTO();
            baseHomePage.setUserWarmLevelDTO(equityDTO);
        }
        return baseHomePage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean sendSystemMessage(Long userId) {
        KeyGenerator keyGenerator = RedisConfig.USER_ACCESS_MESSAGE.copy().appendKey((Object)userId);
        String stringId = String.valueOf(SequenceHolder.nextLongId());
        String lockkey = "homepage:systemmessage:lock:" + userId;
        if (this.distributedLock.lock(lockkey)) {
            try {
                Date sendDate;
                int count;
                boolean flag;
                Long timestamp = (Long)this.redisStringAdapter.get(keyGenerator, Long.class);
                boolean bl = flag = Objects.isNull(timestamp) || !new Date(timestamp).toInstant().atZone(ZoneId.systemDefault()).toLocalDate().equals(LocalDate.now());
                if (flag && (count = this.userVisitService.getInterviewNumByTime(userId, sendDate = Objects.isNull(timestamp) ? this.userLoginHistoryMapper.selectMinLoginTime(userId) : new Date(timestamp)).intValue()) > 0) {
                    log.debug("homepage systemmessage ,userId={},sendTime={}", (Object)userId, (Object)DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                    LocationUserInfoDTO location = null;
                    this.pushMsgIntegrationService.sendSystemMessage(userId, count, location);
                    this.redisStringAdapter.set(keyGenerator, System.currentTimeMillis());
                }
            }
            finally {
                this.distributedLock.unlock(lockkey);
            }
        }
        return Boolean.TRUE;
    }

    private String getGeneration(LocalDate birthday) {
        String generationStr = null;
        if (null != birthday) {
            int year = birthday.getYear();
            int decade = year / 10;
            String s = String.valueOf(decade);
            generationStr = s.substring(s.length() - 1) + "0\u540e";
        }
        return generationStr;
    }

    private KeyGenerator userCoverCache(Long userId) {
        return RedisConfig.USER_COVER_INFO.copy().appendKey((Object)userId);
    }

    @Autowired
    public HomePageServiceImpl(HomePageConfigProperties homePageConfigProperties, RedisStringAdapter redisStringAdapter, UserLoginHistoryMapper userLoginHistoryMapper, PushMsgIntegrationService pushMsgIntegrationService, DistributedLock distributedLock, UserTagService userTagService, UserVisitService userVisitService, NativeUserProperties nativeUserProperties, UserService userService, DomainIntegrationService domainIntegrationService, UserWarmLevelService userWarmLevelService, UserMedalService userMedalService, UserInfoService userInfoService, UserInformationService userInformationService, UserStatisticsService userStatisticsService, UserLocationService userLocationService) {
        this.homePageConfigProperties = homePageConfigProperties;
        this.redisStringAdapter = redisStringAdapter;
        this.userLoginHistoryMapper = userLoginHistoryMapper;
        this.pushMsgIntegrationService = pushMsgIntegrationService;
        this.distributedLock = distributedLock;
        this.userTagService = userTagService;
        this.userVisitService = userVisitService;
        this.nativeUserProperties = nativeUserProperties;
        this.userService = userService;
        this.domainIntegrationService = domainIntegrationService;
        this.userWarmLevelService = userWarmLevelService;
        this.userMedalService = userMedalService;
        this.userInfoService = userInfoService;
        this.userInformationService = userInformationService;
        this.userStatisticsService = userStatisticsService;
        this.userLocationService = userLocationService;
    }
}

