/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.timer;

import com.bxm.component.elasticjob.job.ISimplifyElasticJob;
import com.bxm.egg.user.integration.PushMsgIntegrationService;
import com.bxm.egg.user.login.UserService;
import com.bxm.egg.user.mapper.UserInviteHistoryMapper;
import com.bxm.egg.user.model.dto.LocationUserInfoDTO;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.Interval;
import com.bxm.newidea.component.tools.inner.IntervalMap;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.springframework.stereotype.Component;

@Component
public class UserInvitePushTask
implements ISimplifyElasticJob {
    private final UserInviteHistoryMapper userInviteHistoryMapper;
    private final PushMsgIntegrationService pushMsgIntegrationService;
    private final UserService userService;

    public String cron() {
        return "0 0 8 * * ?";
    }

    public String description() {
        return "\u7528\u6237\u6536\u5f92\u7edf\u8ba1\u4fe1\u606f\u63a8\u9001";
    }

    public void execute(ShardingContext shardingContext) {
        IntervalMap interval = DateUtils.getInterval((Interval)Interval.YESTERDAY);
        List collectByDate = this.userInviteHistoryMapper.getCollectByDate(interval.getStartTime(), interval.getEndTime());
        if (CollectionUtils.isNotEmpty((Collection)collectByDate)) {
            collectByDate.forEach(tuple -> {
                Long userId = Long.valueOf(tuple.getLabel());
                LocationUserInfoDTO location = this.userService.getLocationUserInfo(userId);
                this.pushMsgIntegrationService.pushUserInvite(userId, Integer.valueOf(tuple.getTotal()), location);
            });
        }
    }

    public UserInvitePushTask(UserInviteHistoryMapper userInviteHistoryMapper, PushMsgIntegrationService pushMsgIntegrationService, UserService userService) {
        this.userInviteHistoryMapper = userInviteHistoryMapper;
        this.pushMsgIntegrationService = pushMsgIntegrationService;
        this.userService = userService;
    }
}

