/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.warmlevel.impl;

import com.bxm.egg.user.enums.WarmRuleEnum;
import com.bxm.egg.user.exception.UserAccountException;
import com.bxm.egg.user.param.UserWarmActionParam;
import com.bxm.egg.user.warmlevel.impl.callback.DefaultWarmActionCallback;
import com.bxm.egg.user.warmlevel.impl.callback.WarmActionCallback;
import com.bxm.egg.user.warmlevel.impl.context.WarmActionContext;
import com.bxm.egg.user.warmlevel.impl.handler.DefaultWarmActionHandler;
import com.bxm.egg.user.warmlevel.impl.handler.WarmActionHandler;
import com.bxm.newidea.component.bo.Message;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.RetryException;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
@Transactional(rollbackFor={Exception.class})
public class WarmHandlerProxy {
    private static final Logger log = LoggerFactory.getLogger(WarmHandlerProxy.class);
    private Map<WarmRuleEnum, WarmActionHandler> handlerMap;
    private WarmActionHandler defaultHandler = new DefaultWarmActionHandler();

    @Autowired
    public WarmHandlerProxy(List<WarmActionHandler> handlerList) {
        this.handlerMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(handlerList)) {
            handlerList.forEach(handler -> this.handlerMap.put(handler.support(), (WarmActionHandler)handler));
        }
    }

    @Retryable(value={RetryException.class})
    public Message handle(UserWarmActionParam param) {
        return this.handler(param, null);
    }

    @Retryable(value={RetryException.class})
    public Message handler(UserWarmActionParam param, WarmActionCallback callback) {
        log.debug("\u8fdb\u884c\u8d26\u53f7\u6e29\u6696\u503c\u64cd\u4f5c\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)param);
        if (Objects.isNull(param.getUserId())) {
            return Message.build((boolean)false).setMessage("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        WarmActionContext context = new WarmActionContext(param);
        if (null == callback) {
            callback = new DefaultWarmActionCallback();
        }
        context.setCallback(callback);
        try {
            WarmActionHandler handler = this.handlerMap.getOrDefault(context.getAction(), this.defaultHandler);
            log.debug("\u8d26\u53f7\u64cd\u4f5c\u7684Handler\uff1a{}", (Object)handler.getClass().getSimpleName());
            return handler.handle(context);
        }
        catch (UserAccountException e) {
            log.warn("\u5904\u7406\u6e29\u6696\u503c\u53d1\u751f\u4e1a\u52a1\u5f02\u5e38\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}:\u662f\u5426\u91cd\u8bd5\uff1a{}", new Object[]{context, e.getMessage(), e.isRetryable()});
            if (e.isRetryable()) {
                callback.preRetry(context);
                throw new RetryException(e.getMessage(), (Throwable)e);
            }
            callback.exception(context);
            throw e;
        }
        catch (Exception e) {
            callback.exception(context);
            log.error("\u6e29\u6696\u503c\u5904\u7406\u53d1\u751f\u672a\u9884\u671f\u7684\u9519\u8bef,\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)context);
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

