/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.warmlevel.impl.handler;

import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.enums.WarmRuleEnum;
import com.bxm.egg.user.warmlevel.impl.context.WarmActionContext;
import com.bxm.egg.user.warmlevel.impl.handler.AbstractWarmActionHandler;
import com.bxm.egg.user.warmlevel.impl.rule.LoginRule;
import com.bxm.egg.user.warmlevel.impl.rule.WarmRule;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserLoginActionHandler
extends AbstractWarmActionHandler {
    @Autowired
    private RedisSetAdapter redisSetAdapter;

    @Override
    protected void execAction(WarmActionContext context) {
        context.setWarmRuleDetail(this.getWarmRule(context.getAction().name()));
    }

    @Override
    protected void afterPost(WarmActionContext context) {
        KeyGenerator key = RedisConfig.USER_LOGIN_WARM.copy().appendKey((Object)DateUtils.formatDate((Date)new Date()));
        this.redisSetAdapter.add(key, new Object[]{context.getUserId()});
        this.redisSetAdapter.expire(key, 172800L);
    }

    @Override
    public WarmRuleEnum support() {
        return WarmRuleEnum.LOGIN;
    }

    @Override
    public Class<? extends WarmRule> bindRules() {
        return LoginRule.class;
    }
}

