/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.auth.impl;

import com.bxm.egg.common.enums.AuthCodeEnum;
import com.bxm.egg.common.enums.RoleCodeEnum;
import com.bxm.egg.user.auth.UserAuthCodeService;
import com.bxm.egg.user.constant.AuthRedisKey;
import com.bxm.egg.user.dto.auth.UserAuthResourceDto;
import com.bxm.egg.user.integration.MessageFacadeIntegrationService;
import com.bxm.egg.user.mapper.auth.UserAuthCodeMapper;
import com.bxm.egg.user.mapper.auth.UserAuthIdMapper;
import com.bxm.egg.user.mapper.auth.UserRoleAuthMapper;
import com.bxm.egg.user.mapper.auth.UserRoleMapper;
import com.bxm.egg.user.model.param.RemoveAuthCodeParam;
import com.bxm.egg.user.model.vo.auth.UserAuthCodeBean;
import com.bxm.egg.user.model.vo.auth.UserAuthIdBean;
import com.bxm.egg.user.model.vo.auth.UserRoleAuthBean;
import com.bxm.egg.user.model.vo.auth.UserRoleBean;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.BitOperatorUtil;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserAuthCodeServiceImpl
implements UserAuthCodeService {
    private static final Logger log = LoggerFactory.getLogger(UserAuthCodeServiceImpl.class);
    private RedisHashMapAdapter redisHashMapAdapter;
    private UserAuthCodeMapper userAuthCodeMapper;
    private UserAuthIdMapper userAuthIdMapper;
    private UserRoleAuthMapper userRoleAuthMapper;
    private UserRoleMapper userRoleMapper;
    private MessageFacadeIntegrationService messageSender;
    private TypeReference<List<String>> typeReference = new TypeReference<List<String>>(){};

    public UserAuthCodeServiceImpl(RedisHashMapAdapter redisHashMapAdapter, UserAuthCodeMapper userAuthCodeMapper, UserAuthIdMapper userAuthIdMapper, UserRoleAuthMapper userRoleAuthMapper, UserRoleMapper userRoleMapper, MessageFacadeIntegrationService messageSender) {
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.userAuthCodeMapper = userAuthCodeMapper;
        this.userAuthIdMapper = userAuthIdMapper;
        this.userRoleAuthMapper = userRoleAuthMapper;
        this.userRoleMapper = userRoleMapper;
        this.messageSender = messageSender;
    }

    @Override
    public Long[] getAuthCombineCode(Long userId) {
        Long[] authCodeArray;
        String combineCode = (String)this.redisHashMapAdapter.get(AuthRedisKey.USER_AUTH_CODE, userId.toString(), String.class);
        if (null == combineCode) {
            authCodeArray = new Long[]{0L};
        } else {
            String[] authCodeStrArray = combineCode.split(",");
            authCodeArray = new Long[authCodeStrArray.length];
            for (int i = 0; i < authCodeStrArray.length; ++i) {
                authCodeArray[i] = Long.valueOf(authCodeStrArray[i]);
            }
        }
        return authCodeArray;
    }

    @Override
    public List<UserAuthResourceDto> getAuthResources(Long userId) {
        Map<String, List<String>> authResourceMap = this.redisHashMapAdapter.entries(this.buildKey(userId), this.typeReference);
        if (null == authResourceMap) {
            authResourceMap = this.reloadResourceIdCache(userId);
        }
        return authResourceMap.entrySet().stream().map(entry -> new UserAuthResourceDto(Integer.valueOf((String)entry.getKey()), (List)entry.getValue())).collect(Collectors.toList());
    }

    private Map<String, List<String>> reloadResourceIdCache(Long userId) {
        HashMap cacheMap = Maps.newHashMap();
        List userAuthIdBeans = this.userAuthIdMapper.queryAuthIds(userId);
        userAuthIdBeans.forEach(item -> {
            String key = item.getAuthCode() + "";
            List resourceIds = (List)cacheMap.get(key);
            if (null == resourceIds) {
                resourceIds = Lists.newArrayList();
            }
            resourceIds.add(item.getAuthId());
            cacheMap.put(key, resourceIds);
        });
        KeyGenerator key = this.buildKey(userId);
        this.redisHashMapAdapter.remove(key);
        this.redisHashMapAdapter.putAll(key, (Map)cacheMap);
        return cacheMap;
    }

    @Override
    public Message addRole(Long userId, RoleCodeEnum role) {
        Preconditions.checkArgument((null != role ? 1 : 0) != 0);
        UserRoleBean roleBean = new UserRoleBean();
        roleBean.setId(SequenceHolder.nextLongId());
        roleBean.setCreateTime(new Date());
        roleBean.setRoleCode(role.name());
        roleBean.setUserId(userId);
        this.userRoleMapper.insert(roleBean);
        List authBeans = this.userRoleAuthMapper.queryByCode(role.name());
        Long[] authCombineCode = this.getAuthCombineCode(userId);
        for (UserRoleAuthBean userRoleAuth : authBeans) {
            AuthCodeEnum codeEnum = AuthCodeEnum.getByIndex((Integer)userRoleAuth.getAuthCode());
            authCombineCode = this.changeUserAuthCode(authCombineCode, codeEnum, true);
        }
        Message message = this.saveAuthCode(authCombineCode, userId);
        return message;
    }

    @Override
    public Message removeRole(Long userId, RoleCodeEnum role) {
        Preconditions.checkArgument((null != role ? 1 : 0) != 0);
        Preconditions.checkArgument((null != userId ? 1 : 0) != 0);
        this.userRoleMapper.removeUserRole(userId, role.name());
        List authBeans = this.userRoleAuthMapper.queryByCode(role.name());
        Long[] authCombineCode = this.getAuthCombineCode(userId);
        for (UserRoleAuthBean userRoleAuth : authBeans) {
            AuthCodeEnum codeEnum = AuthCodeEnum.getByIndex((Integer)userRoleAuth.getAuthCode());
            authCombineCode = this.changeUserAuthCode(authCombineCode, codeEnum, false);
        }
        for (UserRoleAuthBean authBean : authBeans) {
            this.userAuthIdMapper.removeAuth(userId, authBean.getAuthCode());
        }
        this.reloadResourceIdCache(userId);
        return this.saveAuthCode(authCombineCode, userId);
    }

    @Override
    public Message addAuthCode(Long userId, AuthCodeEnum authCode) {
        Long[] authCombineCode = this.getAuthCombineCode(userId);
        authCombineCode = this.changeUserAuthCode(authCombineCode, authCode, true);
        return this.saveAuthCode(authCombineCode, userId);
    }

    private Message saveAuthCode(Long[] authCodeArray, Long userId) {
        int rows;
        String authCombineCode = StringUtils.join((Object[])authCodeArray, (String)",");
        this.redisHashMapAdapter.put(AuthRedisKey.USER_AUTH_CODE, userId.toString(), (Object)authCombineCode);
        UserAuthCodeBean entity = this.userAuthCodeMapper.queryByUserId(userId);
        if (entity == null) {
            entity = new UserAuthCodeBean();
            entity.setId(SequenceHolder.nextLongId());
            entity.setCreateTime(new Date());
            entity.setAuthCombineCode(authCombineCode);
            entity.setUserId(userId);
            rows = this.userAuthCodeMapper.insert(entity);
        } else {
            entity.setAuthCombineCode(authCombineCode);
            entity.setModifyTime(new Date());
            rows = this.userAuthCodeMapper.updateByPrimaryKey(entity);
        }
        return Message.build((int)rows);
    }

    private Long[] changeUserAuthCode(Long[] authCombineCode, AuthCodeEnum authCode, boolean isAdd) {
        return BitOperatorUtil.setBitToArray((Long[])authCombineCode, (int)authCode.index, (boolean)isAdd);
    }

    @Override
    public Message removeAuthCode(Long userId, AuthCodeEnum authCode) {
        Long[] authCombineCode = this.getAuthCombineCode(userId);
        authCombineCode = this.changeUserAuthCode(authCombineCode, authCode, false);
        this.userAuthIdMapper.removeAuth(userId, Integer.valueOf(authCode.index));
        this.redisHashMapAdapter.remove(this.buildKey(userId), new String[]{authCode.index + ""});
        return this.saveAuthCode(authCombineCode, userId);
    }

    @Override
    public Message addResource(Long userId, AuthCodeEnum authCode, String resourceId) {
        return this.addResource(userId, authCode, (List<String>)ImmutableList.of((Object)resourceId));
    }

    @Override
    public Boolean hasAuth(Long userId, AuthCodeEnum codeEnum) {
        int authCode = codeEnum.index;
        Long[] parseAuthCodeArray = this.getAuthCombineCode(userId);
        return BitOperatorUtil.hasBit((Long[])parseAuthCodeArray, (int)authCode);
    }

    @Override
    public Message removeResource(Long userId, AuthCodeEnum authCode, String resourceId) {
        String subKey;
        KeyGenerator key = this.buildKey(userId);
        List resources = (List)this.redisHashMapAdapter.get(key, subKey = String.valueOf(authCode.index), this.typeReference);
        if (null != resources) {
            resources.remove(resourceId);
            this.redisHashMapAdapter.put(key, subKey, (Object)resources);
        }
        Message message = Message.build((int)this.userAuthIdMapper.removeAuthId(userId, Integer.valueOf(authCode.index), resourceId));
        return message;
    }

    @Override
    public Message addResource(Long userId, AuthCodeEnum authCode, List<String> resources) {
        Preconditions.checkArgument((null != resources ? 1 : 0) != 0);
        KeyGenerator key = this.buildKey(userId);
        String subKey = String.valueOf(authCode.index);
        List existsResources = (List)this.redisHashMapAdapter.get(key, subKey, this.typeReference);
        if (null == existsResources) {
            existsResources = Lists.newArrayList();
        }
        existsResources.addAll(resources);
        this.redisHashMapAdapter.put(key, subKey, (Object)existsResources);
        ArrayList userAuthIdBeans = Lists.newArrayList();
        Date now = new Date();
        for (String string : resources) {
            UserAuthIdBean entity = new UserAuthIdBean();
            entity.setAuthCode(Integer.valueOf(authCode.index));
            entity.setId(SequenceHolder.nextLongId());
            entity.setAuthId(string);
            entity.setUserId(userId);
            entity.setCreateTime(now);
            userAuthIdBeans.add(entity);
        }
        int successTotal = 0;
        for (UserAuthIdBean userAuthIdBean : userAuthIdBeans) {
            this.userAuthIdMapper.insert(userAuthIdBean);
            ++successTotal;
        }
        boolean bl = successTotal == userAuthIdBeans.size();
        return Message.build((boolean)bl);
    }

    @Override
    public Message addRemoveAuthCodeTask(RemoveAuthCodeParam param) {
        return Message.build((boolean)true);
    }

    @Override
    public Message removeAuthCodeTask(Long userId) {
        return Message.build((boolean)true);
    }

    private KeyGenerator buildKey(Long userId) {
        return AuthRedisKey.USER_AUTH_RESOURCE.copy().appendKey((Object)userId.toString());
    }
}

