/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.equitylevelmedal.impl;

import com.bxm.egg.user.enums.WarmValueEquityEnum;
import com.bxm.egg.user.equitylevelmedal.UserEquityLevelMedalService;
import com.bxm.egg.user.mapper.medal.UserMedalRelationInfoMapper;
import com.bxm.egg.user.model.UserEquityDTO;
import com.bxm.egg.user.model.WearMedalDTO;
import com.bxm.egg.user.model.dto.warmlevel.UserWarmLevelInfoDTO;
import com.bxm.egg.user.model.equitylevelmedal.UserEquityLevelInfoDTO;
import com.bxm.egg.user.model.equitylevelmedal.UserEquityLevelMedalInfoDTO;
import com.bxm.egg.user.warmlevel.UserWarmLevelService;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserEquityLevelMedalServiceImpl
implements UserEquityLevelMedalService {
    private static final Logger log = LoggerFactory.getLogger(UserEquityLevelMedalServiceImpl.class);
    @Autowired
    private UserWarmLevelService userWarmLevelService;
    @Autowired
    private UserMedalRelationInfoMapper userMedalRelationInfoMapper;

    @Override
    public List<UserEquityLevelMedalInfoDTO> getEquityLevelMedalList(List<Long> userIdList) {
        return userIdList.stream().map(this::builderEquityLevelMedal).collect(Collectors.toList());
    }

    @Override
    public List<UserEquityLevelInfoDTO> getEquityLevelInfoList(List<Long> userIdList, Boolean showLevelRule) {
        return userIdList.stream().map(userId -> {
            UserEquityLevelInfoDTO equityLevelInfoDTO = UserEquityLevelInfoDTO.builder().build();
            equityLevelInfoDTO.setUserId(userId);
            UserWarmLevelInfoDTO userWarmInfoCache = this.userWarmLevelService.getUserWarmInfoCache((Long)userId);
            if (showLevelRule.booleanValue()) {
                String[] equityType = userWarmInfoCache.getEquityDTO().getEquityType();
                if (Objects.nonNull(equityType) && equityType.length > 0) {
                    List<String> equityList = Arrays.asList(equityType);
                    equityLevelInfoDTO.setUserEquityDTO(equityList.contains(WarmValueEquityEnum.LEVEL_SHOW.name()) ? userWarmInfoCache.getEquityDTO() : UserEquityDTO.builder().showLevel(Boolean.valueOf(false)).build());
                }
            } else {
                equityLevelInfoDTO.setUserEquityDTO(userWarmInfoCache.getEquityDTO());
            }
            return equityLevelInfoDTO;
        }).collect(Collectors.toList());
    }

    @Override
    public UserEquityLevelMedalInfoDTO getEquityLevelMedalInfo(Long userId) {
        return this.builderEquityLevelMedal(userId);
    }

    private UserEquityLevelMedalInfoDTO builderEquityLevelMedal(Long userId) {
        UserWarmLevelInfoDTO userWarmInfoCache = this.userWarmLevelService.getUserWarmInfoCache(userId);
        List allWearMedalInfoList = this.userMedalRelationInfoMapper.getAllWearMedalInfo(userId);
        List wearMedalDTOList = allWearMedalInfoList.stream().map(item -> {
            WearMedalDTO wearMedalDTO = new WearMedalDTO();
            BeanUtils.copyProperties((Object)item, (Object)wearMedalDTO);
            return wearMedalDTO;
        }).collect(Collectors.toList());
        return UserEquityLevelMedalInfoDTO.builder().userEquityDTO(userWarmInfoCache.getEquityDTO()).userId(userId).wearMedalDTOList(wearMedalDTOList).build();
    }

    @Override
    public int getUserMedalNum(Long userId) {
        int achievementMedalNum = this.userMedalRelationInfoMapper.countUserAchievementMedalNum(userId);
        int customMedalNum = this.userMedalRelationInfoMapper.countUserCustomMedalNum(userId);
        return achievementMedalNum + customMedalNum;
    }
}

