/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.facade;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.common.enums.UserStatusEnum;
import com.bxm.egg.user.facade.bo.UserInfoBO;
import com.bxm.egg.user.facade.bo.UserStatisticsBO;
import com.bxm.egg.user.facade.service.UserInfoFacadeService;
import com.bxm.egg.user.info.UserInfoCacheService;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.info.UserInformationService;
import com.bxm.egg.user.info.UserStatisticsService;
import com.bxm.egg.user.model.bo.UserCacheInfoBO;
import com.bxm.egg.user.model.bo.UserLocationBO;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.entity.UserInformationEntity;
import com.bxm.egg.user.model.entity.UserStatisticsEntity;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

@DubboService(protocol={"dubbo"}, version="1.0.0")
public class UserInfoFacadeServiceImpl
implements UserInfoFacadeService {
    private static final Logger log = LoggerFactory.getLogger(UserInfoFacadeServiceImpl.class);
    @Resource
    private UserInfoCacheService userInfoCacheService;
    @Resource
    private UserStatisticsService userStatisticsService;
    @Resource
    private UserInformationService userInformationService;
    @Resource
    private UserInfoService userInfoService;

    public UserInfoBO selectUserFromCache(Long userId) {
        if (Objects.isNull(userId)) {
            log.error("\u7528\u6237\u4f20\u9012\u7684\u7528\u6237id\u4e3anull,\u8fd4\u56de\u9ed8\u8ba4\u7528\u6237\u4fe1\u606f");
            return this.buildInvalidUserCacheInfo(userId);
        }
        UserCacheInfoBO userCacheInfoBO = this.userInfoCacheService.load(userId);
        UserInfoBO userInfoBO = new UserInfoBO();
        BeanUtils.copyProperties((Object)userCacheInfoBO, (Object)userInfoBO);
        UserLocationBO userLocationBO = userCacheInfoBO.getUserLocationBO();
        if (userLocationBO != null) {
            userInfoBO.setLocationCode(userLocationBO.getLocationCode());
            userInfoBO.setLocationName(userLocationBO.getLocationName());
        }
        if (log.isDebugEnabled()) {
            log.debug("\u5185\u90e8\u63a5\u53e3\u67e5\u8be2\u7528\u6237\u7f13\u5b58\uff0c\u7528\u6237id:{}, \u7528\u6237\u4fe1\u606f\uff1a{}", (Object)userId, (Object)JSON.toJSONString((Object)userCacheInfoBO));
        }
        return userInfoBO;
    }

    public List<UserInfoBO> selectUserListFromCache(List<Long> userIdList) {
        if (CollectionUtils.isEmpty(userIdList)) {
            return Collections.EMPTY_LIST;
        }
        return userIdList.stream().map(this::selectUserFromCache).collect(Collectors.toList());
    }

    public Map<Long, UserInfoBO> selectUserMapFromCache(List<Long> userIdList) {
        return this.selectUserListFromCache(userIdList).stream().collect(Collectors.groupingBy(UserInfoBO::getUserId, Collectors.collectingAndThen(Collectors.toList(), value -> (UserInfoBO)value.get(0))));
    }

    public UserStatisticsBO getUserStatisticsInfo(Long userId) {
        UserStatisticsEntity userStatisticsEntity = this.userStatisticsService.selectUserStatisticsByUserId(userId);
        UserStatisticsBO userStatisticsBO = new UserStatisticsBO();
        if (userStatisticsEntity != null) {
            BeanUtils.copyProperties((Object)userStatisticsEntity, (Object)userStatisticsBO);
        }
        return userStatisticsBO;
    }

    public Long getInfoCompleteState(Long userId) {
        UserInformationEntity userInformationEntity = this.userInformationService.getUserInformationByUserId(userId);
        if (userInformationEntity != null) {
            return userInformationEntity.getInfoCompleteState();
        }
        return 0L;
    }

    public Boolean isNewPlatformUser(Long userId) {
        UserInfoEntity userInfoEntity = this.userInfoService.selectUserById(userId);
        if (userInfoEntity == null) {
            return false;
        }
        Integer eggUser = userInfoEntity.getEggUser();
        return eggUser == 0;
    }

    private UserInfoBO buildInvalidUserCacheInfo(Long userId) {
        UserInfoBO userCacheInfoBO = new UserInfoBO();
        userCacheInfoBO.setHeadImg("http://bxm-news.oss-cn-hangzhou.aliyuncs.com/img/defaultHeadImg.jpeg");
        userCacheInfoBO.setUserId(userId);
        userCacheInfoBO.setNickname("\u672a\u77e5\u7528\u6237");
        userCacheInfoBO.setState(Integer.valueOf(UserStatusEnum.DISABLE.getCode()));
        return userCacheInfoBO;
    }
}

