/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.follow.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.component.mybatis.dto.PlusPageModelDTO;
import com.bxm.egg.common.enums.UserStatusEnum;
import com.bxm.egg.user.attribute.UserAttributeService;
import com.bxm.egg.user.attribute.UserFunsService;
import com.bxm.egg.user.attribute.UserTagService;
import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.enums.UserFollowStatusEnum;
import com.bxm.egg.user.equitylevelmedal.impl.UserEquityLevelMedalServiceImpl;
import com.bxm.egg.user.follow.UserFollowService;
import com.bxm.egg.user.info.UserInfoCacheService;
import com.bxm.egg.user.integration.MessageFacadeIntegrationService;
import com.bxm.egg.user.integration.NewsIntegrationService;
import com.bxm.egg.user.integration.UserSyncIntegrationService;
import com.bxm.egg.user.integration.sync.SixEnjoyFriendsIntegrationService;
import com.bxm.egg.user.mapper.UserFollowMapper;
import com.bxm.egg.user.mapper.UserFunsMapper;
import com.bxm.egg.user.model.UserEquityDTO;
import com.bxm.egg.user.model.bo.UserCacheInfoBO;
import com.bxm.egg.user.model.dto.warmlevel.UserWarmLevelInfoDTO;
import com.bxm.egg.user.model.param.UserFollowParam;
import com.bxm.egg.user.model.vo.UserFollow;
import com.bxm.egg.user.model.vo.UserFollowRecord;
import com.bxm.egg.user.properties.NativeUserProperties;
import com.bxm.egg.user.warmlevel.UserWarmLevelService;
import com.bxm.newidea.component.dto.IPageModel;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserFollowServiceImpl
implements UserFollowService {
    private static final Logger log = LoggerFactory.getLogger(UserFollowServiceImpl.class);
    private static final String USER_FOLLOW = "USER_FOLLOW_";
    private static final Long FOLLOW_CACHE_EXPIRED = 1296000L;
    @Resource
    private UserFollowMapper userFollowMapper;
    @Resource
    private UserFunsMapper userFunsMapper;
    @Resource
    private UserAttributeService userAttributeService;
    @Resource
    private RedisSetAdapter redisSetAdapter;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private DistributedLock distributedLock;
    @Resource
    private UserFunsService userFunsService;
    @Resource
    private MessageFacadeIntegrationService messageFacadeIntegrationService;
    @Resource
    private NativeUserProperties nativeUserProperties;
    @Resource
    private NewsIntegrationService newsIntegrationService;
    @Resource
    private UserTagService userTagService;
    @Autowired
    private UserWarmLevelService userWarmLevelService;
    @Autowired
    private UserEquityLevelMedalServiceImpl userEquityLevelMedalService;
    @Resource
    private UserInfoCacheService userInfoCacheService;
    @Resource
    private UserSyncIntegrationService userSyncIntegrationService;
    @Resource
    private SixEnjoyFriendsIntegrationService sixEnjoyFriendsIntegrationService;

    @Override
    public Boolean isFollowed(Long currentUserId, Long targetUserId) {
        KeyGenerator keyGenerator = this.getFollowRedisKey(currentUserId);
        if (!this.redisSetAdapter.hasKey(keyGenerator).booleanValue()) {
            List targetUserIdList = this.userFollowMapper.getFollowedUserIdList(currentUserId);
            if (CollectionUtils.isEmpty((Collection)targetUserIdList)) {
                this.redisSetAdapter.add(keyGenerator, new Object[]{-1L});
                return false;
            }
            this.redisSetAdapter.add(keyGenerator, targetUserIdList.toArray());
        }
        return this.redisSetAdapter.exists(keyGenerator, (Object)targetUserId);
    }

    @Override
    public List<Long> isFolloweds(Long currentUserId, List<Long> targetUserIds) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (Long targetUserId : targetUserIds) {
            if (!this.isFollowed(currentUserId, targetUserId).booleanValue()) continue;
            result.add(targetUserId);
        }
        return result;
    }

    @Override
    public Boolean hasFollowMsg(Long userId, Long targetUserId) {
        KeyGenerator key = RedisConfig.COMSUME_FOLLOW_INFO.copy().appendKey((Object)userId).appendKey((Object)targetUserId);
        if (this.redisStringAdapter.hasKey(key).booleanValue()) {
            this.redisStringAdapter.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public Boolean follow(Long userId, Long followUserId, Byte type) {
        if (this.notValidUser(userId) || this.notValidUser(followUserId)) {
            return false;
        }
        if (Objects.equals(userId, followUserId)) {
            log.warn("\u7528\u6237: {} \u81ea\u5df1\u5173\u6ce8\u81ea\u5df1", (Object)userId);
            return true;
        }
        String lockKey = USER_FOLLOW + userId + "_" + followUserId;
        if (this.distributedLock.lock(lockKey)) {
            boolean currentFollow = this.isFollowed(userId, followUserId);
            boolean targetFollow = this.isFollowed(followUserId, userId);
            if (UserFollowStatusEnum.FOLLOW.getCode() == type.byteValue() && !currentFollow) {
                if (targetFollow) {
                    this.addFollow(userId, followUserId, UserFollowStatusEnum.EACH_FOLLOW.getCode());
                    this.modifyFollow(followUserId, userId, UserFollowStatusEnum.EACH_FOLLOW.getCode());
                    this.userFunsService.setFuns(userId, followUserId, UserFollowStatusEnum.EACH_FOLLOW.getCode());
                    this.userFunsService.addFuns(followUserId, userId, UserFollowStatusEnum.EACH_FOLLOW.getCode());
                    this.sixEnjoyFriendsIntegrationService.insertFriendsToSixEnjoy(userId, followUserId);
                } else {
                    this.addFollow(userId, followUserId, UserFollowStatusEnum.FOLLOW.getCode());
                    this.userFunsService.addFuns(followUserId, userId, UserFollowStatusEnum.FOLLOW.getCode());
                }
                this.userAttributeService.addUserFollowCount(userId, followUserId, true);
                this.messageFacadeIntegrationService.addFollowMessage(followUserId);
                this.userSyncIntegrationService.addFollow(userId, followUserId);
            } else if (UserFollowStatusEnum.UNFOLLOW.getCode() == type.byteValue() && currentFollow) {
                this.userFunsService.removeFuns(followUserId, userId);
                this.removeFollow(userId, followUserId);
                if (targetFollow) {
                    this.modifyFollow(followUserId, userId, UserFollowStatusEnum.FOLLOW.getCode());
                    this.userFunsService.setFuns(userId, followUserId, UserFollowStatusEnum.FOLLOW.getCode());
                }
                this.userAttributeService.addUserFollowCount(userId, followUserId, false);
                this.userSyncIntegrationService.removeFollow(userId, followUserId);
                this.sixEnjoyFriendsIntegrationService.delFriendsToSixEnjoy(userId, followUserId);
            }
            this.distributedLock.unlock(lockKey);
        }
        return true;
    }

    private void addFollow(Long userId, Long followId, byte type) {
        UserFollowRecord follow = new UserFollowRecord();
        follow.setUserId(userId);
        follow.setFollowedUserId(followId);
        follow.setType(Byte.valueOf(type));
        int update = this.userFollowMapper.updateFollowedStatus(follow);
        if (0 == update) {
            follow.setId(SequenceHolder.nextLongId());
            this.userFollowMapper.insertFollowed(follow);
        }
        this.redisSetAdapter.add(this.getFollowRedisKey(userId), new Object[]{followId});
        KeyGenerator comsumeKey = RedisConfig.COMSUME_FOLLOW_INFO.copy().appendKey((Object)followId).appendKey((Object)userId);
        this.redisStringAdapter.set(comsumeKey, (Object)"", FOLLOW_CACHE_EXPIRED.longValue());
    }

    private void modifyFollow(Long userId, Long followId, byte type) {
        if (UserFollowStatusEnum.UNFOLLOW.getCode() == type) {
            this.removeFollow(userId, followId);
        } else {
            UserFollowRecord follow = new UserFollowRecord();
            follow.setUserId(userId);
            follow.setFollowedUserId(followId);
            follow.setType(Byte.valueOf(type));
            this.userFollowMapper.updateFollowedStatus(follow);
        }
    }

    private void removeFollow(Long userId, Long followId) {
        UserFollowRecord follow = new UserFollowRecord();
        follow.setUserId(userId);
        follow.setFollowedUserId(followId);
        follow.setType(Byte.valueOf(UserFollowStatusEnum.UNFOLLOW.getCode()));
        this.userFollowMapper.updateFollowedStatus(follow);
        this.redisSetAdapter.remove(this.getFollowRedisKey(userId), new Object[]{followId});
    }

    @Override
    public IPageModel<UserFollow> followList(UserFollowParam param) {
        Page queryParam = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue());
        IPage pageResult = this.userFollowMapper.queryFollowByPage((IPage)queryParam, param);
        this.fillExtraInfo(pageResult.getRecords());
        return PlusPageModelDTO.build((IPage)pageResult);
    }

    @Override
    public IPageModel<UserFollow> queryFunsByPage(UserFollowParam param) {
        Page queryParam = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue());
        IPage pageResult = this.userFunsMapper.queryFunsByPage((IPage)queryParam, param);
        this.fillExtraInfo(pageResult.getRecords());
        for (UserFollow record : pageResult.getRecords()) {
            if (!Objects.equals(record.getStatus(), UserFollowStatusEnum.FOLLOW.getCode())) continue;
            record.setStatus(Byte.valueOf(UserFollowStatusEnum.UNFOLLOW.getCode()));
        }
        return PlusPageModelDTO.build((IPage)pageResult);
    }

    @Override
    public List<Long> followUserIdList(Long userId) {
        Set list = this.redisSetAdapter.getAllMembers(this.getFollowRedisKey(userId), Long.class);
        return new ArrayList<Long>(list);
    }

    private KeyGenerator getFollowRedisKey(Long userId) {
        return RedisConfig.USER_FOLLOW_LIST.copy().appendKey((Object)userId);
    }

    private void fillExtraInfo(List<UserFollow> resultList) {
        if (!CollectionUtils.isEmpty(resultList)) {
            List<UserCacheInfoBO> userInfoList = this.batchLoadFormCache(resultList);
            resultList.forEach(userFollow -> {
                Optional<UserCacheInfoBO> userInfoOptional = userInfoList.stream().filter(user -> user.getUserId().equals(userFollow.getUserId())).findFirst();
                if (userInfoOptional.isPresent()) {
                    UserCacheInfoBO userInfo = userInfoOptional.get();
                    userFollow.setNickname(userInfo.getNickname());
                    userFollow.setHeadImg(userInfo.getHeadImg());
                    userFollow.setSex(userInfo.getSex());
                    if (Objects.equals(userInfo.getUserInformationBO().getIsDefaultPersonalProfile(), Boolean.TRUE)) {
                        userFollow.setPersonalProfile(this.nativeUserProperties.getDefaultPersonalProfile());
                    } else {
                        userFollow.setPersonalProfile(userInfo.getUserInformationBO().getPersonalProfile());
                    }
                }
                UserWarmLevelInfoDTO userWarmInfoCache = this.userWarmLevelService.getUserWarmInfoCache(userFollow.getUserId());
                UserEquityDTO equityDTO = userWarmInfoCache.getEquityDTO();
                userFollow.setUserWarmLevelDTO(equityDTO);
            });
        }
    }

    private List<UserCacheInfoBO> batchLoadFormCache(List<UserFollow> resultList) {
        Set<Long> originUserIds = resultList.stream().map(UserFollow::getUserId).collect(Collectors.toSet());
        return this.userInfoCacheService.getBatchUserInfo(originUserIds);
    }

    private boolean notValidUser(Long userId) {
        UserCacheInfoBO userCacheInfoBO = this.userInfoCacheService.load(userId);
        return null == userCacheInfoBO || Objects.equals(UserStatusEnum.DISABLE.getCode(), userCacheInfoBO.getState());
    }
}

