/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.follow.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.component.mybatis.dto.PlusPageModelDTO;
import com.bxm.egg.user.attribute.UserTagService;
import com.bxm.egg.user.equitylevelmedal.impl.UserEquityLevelMedalServiceImpl;
import com.bxm.egg.user.follow.UserFollowService;
import com.bxm.egg.user.follow.UserRecommendFollowService;
import com.bxm.egg.user.info.UserInfoCacheService;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.integration.NewsIntegrationService;
import com.bxm.egg.user.integration.UserNewsIntegrationService;
import com.bxm.egg.user.model.bo.UserCacheInfoBO;
import com.bxm.egg.user.model.dto.ImgDTO;
import com.bxm.egg.user.model.dto.NoteDTO;
import com.bxm.egg.user.model.equitylevelmedal.UserEquityLevelMedalInfoDTO;
import com.bxm.egg.user.model.param.RecommendFollowUsersParam;
import com.bxm.egg.user.model.vo.RecommendFollowUsersVo;
import com.bxm.egg.user.model.vo.UserTag;
import com.bxm.egg.user.support.NativeUserService;
import com.bxm.egg.user.utils.ConstellationUtils;
import com.bxm.egg.user.vo.RecommendUserFacadeVo;
import com.bxm.newidea.component.dto.IPageModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserRecommendFollowServiceImpl
implements UserRecommendFollowService {
    private static final Logger log = LoggerFactory.getLogger(UserRecommendFollowServiceImpl.class);
    @Resource
    private NewsIntegrationService newsIntegrationService;
    @Resource
    private NativeUserService nativeUserService;
    @Resource
    private UserNewsIntegrationService userNewsIntegrationService;
    @Resource
    private UserTagService userTagService;
    @Autowired
    private UserEquityLevelMedalServiceImpl userEquityLevelMedalService;
    @Resource
    private UserInfoCacheService userInfoCacheService;
    @Resource
    private UserInfoService userInfoService;
    @Resource
    private UserFollowService userFollowService;

    @Override
    public IPageModel<RecommendFollowUsersVo> getRecommendFollowUsers(RecommendFollowUsersParam param) {
        List<Long> userIdsForCurrentPage;
        Page forumPostPage = new Page();
        ArrayList followedUserList = this.userFollowService.followUserIdList(param.getUserId());
        if (!CollectionUtils.isEmpty(followedUserList)) {
            followedUserList.add((Long)param.getUserId());
        } else {
            followedUserList = Lists.newArrayList((Object[])new Long[]{param.getUserId()});
        }
        List recommendUserIds = this.newsIntegrationService.getRecommendUserList(param.getAreaCode(), param.getUserId()).stream().filter(item -> this.userInfoService.selectUserById(item.getUserId()) != null).collect(Collectors.toList());
        List userIds = recommendUserIds.stream().map(RecommendUserFacadeVo::getUserId).collect(Collectors.toList());
        int start = (param.getPageNum() - 1) * param.getPageSize();
        int end = param.getPageNum() * param.getPageSize();
        if (start < 0) {
            start = 0;
        }
        if (end > userIds.size()) {
            end = userIds.size();
        }
        if (CollectionUtils.isEmpty(userIdsForCurrentPage = userIds.subList(start, end))) {
            forumPostPage.setRecords(Collections.emptyList());
            return PlusPageModelDTO.build((IPage)forumPostPage);
        }
        List<RecommendFollowUsersVo> resultList = new ArrayList<RecommendFollowUsersVo>();
        for (Long userId : userIdsForCurrentPage) {
            RecommendFollowUsersVo recommendFollowUsersVo = new RecommendFollowUsersVo();
            recommendFollowUsersVo.setUserId(userId);
            resultList.add(recommendFollowUsersVo);
        }
        resultList = this.fillRecommendUserInfo(resultList, userIdsForCurrentPage, param);
        forumPostPage.setRecords(resultList);
        return PlusPageModelDTO.build((IPage)forumPostPage);
    }

    private List<RecommendFollowUsersVo> fillRecommendUserInfo(List<RecommendFollowUsersVo> list, List<Long> userIdList, RecommendFollowUsersParam param) {
        if (!CollectionUtils.isEmpty(list)) {
            List<UserCacheInfoBO> userInfoList = this.userInfoCacheService.getBatchUserInfo(userIdList);
            List<UserEquityLevelMedalInfoDTO> equityLevelMedalList = this.userEquityLevelMedalService.getEquityLevelMedalList(userIdList);
            Map<Long, List<UserEquityLevelMedalInfoDTO>> equityMedalMap = equityLevelMedalList.stream().collect(Collectors.groupingBy(UserEquityLevelMedalInfoDTO::getUserId));
            Map<Long, List<UserTag>> userTagMap = this.userTagService.getBatchUserTag(userIdList);
            AtomicReference<Map<Long, List<ImgDTO>>> imgMap = new AtomicReference<Map<Long, List<ImgDTO>>>(Maps.newHashMap());
            AtomicReference<Map<Long, NoteDTO>> noteMap = new AtomicReference<Map<Long, NoteDTO>>(Maps.newHashMap());
            this.asyncFillContent(imgMap, noteMap, userIdList, param.getUserId());
            list.forEach(recommendFollowUsersVo -> {
                Optional<UserCacheInfoBO> optional = userInfoList.stream().filter(user -> user.getUserId().equals(recommendFollowUsersVo.getUserId())).findFirst();
                if (optional.isPresent()) {
                    List imgList;
                    UserCacheInfoBO userInfo = optional.get();
                    recommendFollowUsersVo.setNickname(userInfo.getNickname());
                    recommendFollowUsersVo.setHeadImg(Objects.nonNull(userInfo.getHeadImg()) ? userInfo.getHeadImg() : null);
                    recommendFollowUsersVo.setSex(userInfo.getSex());
                    recommendFollowUsersVo.setDesc(Objects.nonNull(userInfo.getUserInformationBO().getPersonalProfile()) && !userInfo.getUserInformationBO().getPersonalProfile().startsWith("\u4e00\u53e5\u8bdd\u4ecb\u7ecd\u4e0b\u81ea\u5df1") ? "\u5173\u4e8eTA:" + userInfo.getUserInformationBO().getPersonalProfile() : (Objects.nonNull(((Map)noteMap.get()).get(recommendFollowUsersVo.getUserId())) && Objects.nonNull(((NoteDTO)((Map)noteMap.get()).get(recommendFollowUsersVo.getUserId())).getTextField()) ? "\u5173\u4e8eTA:" + ((NoteDTO)((Map)noteMap.get()).get(recommendFollowUsersVo.getUserId())).getTextField() : null));
                    recommendFollowUsersVo.setFollowed(Integer.valueOf(this.userFollowService.isFollowed(param.getUserId(), recommendFollowUsersVo.getUserId()) != false ? 1 : 0));
                    if (Objects.nonNull(userInfo.getUserInformationBO().getBirthday())) {
                        LocalDate birthday = userInfo.getUserInformationBO().getBirthday().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        recommendFollowUsersVo.setConstellation(ConstellationUtils.calculateConstellation((LocalDate)birthday));
                        recommendFollowUsersVo.setGeneration(this.nativeUserService.getGeneration(userInfo.getUserInformationBO().getBirthday()));
                    }
                    if (!CollectionUtils.isEmpty((Collection)(imgList = (List)((Map)imgMap.get()).get(recommendFollowUsersVo.getUserId())))) {
                        recommendFollowUsersVo.setImgInfo(imgList.size() > 3 ? imgList.subList(0, 3) : imgList);
                    }
                    List<Object> userLabels = new ArrayList();
                    List userTagList = (List)userTagMap.get(recommendFollowUsersVo.getUserId());
                    if (!CollectionUtils.isEmpty((Collection)userTagList)) {
                        userLabels = userTagList.stream().filter(t -> t.getDeleteFlag() == 0).map(UserTag::getLabel).collect(Collectors.toList());
                    }
                    recommendFollowUsersVo.setUserLabels(userLabels);
                    List userEquityLevelMedalInfoDTOS = (List)equityMedalMap.get(recommendFollowUsersVo.getUserId());
                    if (!CollectionUtils.isEmpty((Collection)userEquityLevelMedalInfoDTOS)) {
                        UserEquityLevelMedalInfoDTO userEquityLevelMedalInfoDTO = (UserEquityLevelMedalInfoDTO)userEquityLevelMedalInfoDTOS.get(0);
                        recommendFollowUsersVo.setUserWarmLevelDTO(userEquityLevelMedalInfoDTO.getUserEquityDTO());
                    }
                }
            });
            list = list.stream().filter(recommendFollowUsersVo -> !CollectionUtils.isEmpty((Collection)recommendFollowUsersVo.getImgInfo()) && recommendFollowUsersVo.getImgInfo().size() >= 3).collect(Collectors.toList());
        }
        return list;
    }

    private void asyncFillContent(AtomicReference<Map<Long, List<ImgDTO>>> imgMap, AtomicReference<Map<Long, NoteDTO>> noteMap, List<Long> userIdList, Long currentUserId) {
        CompletionStage img = CompletableFuture.supplyAsync(() -> {
            imgMap.set(this.userNewsIntegrationService.batchGetAllUserImg(userIdList, currentUserId));
            return (Map)imgMap.get();
        }).whenCompleteAsync((t, u) -> {
            if (Objects.nonNull(u)) {
                log.error("\u5f02\u6b65\u83b7\u53d6\u7528\u6237\u5e16\u5b50\u56fe\u7247\u96c6\u5408\u5931\u8d25 error : {}", u);
            }
            log.info("\u5f02\u6b65\u83b7\u53d6\u5e16\u5b50\u56fe\u7247\u96c6\u5408\u5b8c\u6210\u3002\u3002");
        });
        CompletableFuture<Void> all = CompletableFuture.allOf(new CompletableFuture[]{img});
        try {
            all.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
        }
    }
}

