/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.info.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.component.mybatis.dto.PlusPageModelDTO;
import com.bxm.egg.mq.common.constant.PushMessageEnum;
import com.bxm.egg.mq.common.constant.TemplateTypeEnum;
import com.bxm.egg.mq.common.model.dto.PushMessage;
import com.bxm.egg.mq.common.model.dto.PushPayloadInfo;
import com.bxm.egg.mq.common.model.dto.PushReceiveScope;
import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.enums.UserCoverStatusEnum;
import com.bxm.egg.user.enums.WarmValueEquityEnum;
import com.bxm.egg.user.info.UserCoverService;
import com.bxm.egg.user.integration.MessageFacadeIntegrationService;
import com.bxm.egg.user.mapper.UserCoverMapper;
import com.bxm.egg.user.model.UserEquityDTO;
import com.bxm.egg.user.model.dto.UserCoverDTO;
import com.bxm.egg.user.model.dto.UserCoverListDTO;
import com.bxm.egg.user.model.dto.warmlevel.UserWarmLevelInfoDTO;
import com.bxm.egg.user.model.param.UserCenterCoverParam;
import com.bxm.egg.user.model.param.UserCoverAuditParam;
import com.bxm.egg.user.model.param.UserCoverListParam;
import com.bxm.egg.user.model.vo.UserCover;
import com.bxm.egg.user.warmlevel.UserWarmLevelService;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.dto.IPageModel;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserCoverServiceImpl
implements UserCoverService {
    private static final Logger log = LoggerFactory.getLogger(UserCoverServiceImpl.class);
    private final RedisStringAdapter redisStringAdapter;
    private final UserWarmLevelService userWarmLevelService;
    private final UserCoverMapper userCoverMapper;
    private final MessageFacadeIntegrationService messageSender;

    @Override
    public Message uploadCover(UserCenterCoverParam param) {
        UserWarmLevelInfoDTO userWarmInfoCache = this.userWarmLevelService.getUserWarmInfoCache(param.getUserId());
        if (Objects.isNull(userWarmInfoCache)) {
            return Message.build((boolean)Boolean.FALSE).setMessage("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        UserEquityDTO equityDTO = userWarmInfoCache.getEquityDTO();
        if (Objects.isNull(equityDTO)) {
            return Message.build((boolean)Boolean.FALSE).setMessage("\u7528\u6237\u7b49\u7ea7\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        String[] equityType = equityDTO.getEquityType();
        if (Objects.isNull(equityType)) {
            return Message.build((boolean)Boolean.FALSE).setMessage("\u7528\u6237\u7b49\u7ea7\u4e0d\u7b26\u5408\u66f4\u6362\u5c01\u9762");
        }
        if (!Arrays.asList(equityType).contains(WarmValueEquityEnum.USER_COVER.name())) {
            return Message.build((boolean)Boolean.FALSE).setMessage("\u7528\u6237\u7b49\u7ea7\u4e0d\u7b26\u5408\u66f4\u6362\u5c01\u9762");
        }
        UserCover lastCoverInfoByStatus = this.userCoverMapper.getLastCoverInfoByStatus(param.getUserId(), Integer.valueOf(0));
        if (Objects.nonNull(lastCoverInfoByStatus)) {
            return Message.build((boolean)Boolean.FALSE).setMessage("\u5df2\u6709\u5f85\u5ba1\u6838\u7684\u5c01\u9762\uff0c\u8bf7\u5ba1\u6838\u540e\u518d\u505a\u4fee\u6539");
        }
        UserCover userCover = new UserCover();
        userCover.setCoverUrl(param.getUrl());
        userCover.setCreateTime(new Date());
        userCover.setId(SequenceHolder.nextLongId());
        userCover.setUserId(param.getUserId());
        userCover.setNickname(userWarmInfoCache.getNickname());
        userCover.setStatus(Integer.valueOf(0));
        this.userCoverMapper.insertSelective(userCover);
        UserCover auditSuccess = this.userCoverMapper.getLastCoverInfoByStatus(param.getUserId(), Integer.valueOf(1));
        UserCoverDTO userCoverDTO = new UserCoverDTO();
        userCoverDTO.setUserId(param.getUserId());
        if (Objects.nonNull(auditSuccess)) {
            userCoverDTO.setAuditCover(auditSuccess.getCoverUrl());
        }
        userCoverDTO.setNoAuditCover(param.getUrl());
        this.redisStringAdapter.set(this.userCoverCache(param.getUserId()), (Object)userCoverDTO);
        return Message.build((boolean)true).setMessage("\u8bf7\u7b49\u5f85\u5de5\u4f5c\u4eba\u5458\u5ba1\u6838");
    }

    private KeyGenerator userCoverCache(Long userId) {
        return RedisConfig.USER_COVER_INFO.copy().appendKey((Object)userId);
    }

    @Override
    public Message auditUserCover(UserCoverAuditParam param) {
        UserCover userCover = this.userCoverMapper.selectByPrimaryKey(param.getId());
        if (Objects.isNull(userCover)) {
            return Message.build((boolean)false).setMessage("\u5ba1\u6838\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (Objects.equals(userCover.getStatus(), UserCoverStatusEnum.AUDIT_PASS.getStatus())) {
            return Message.build((boolean)false).setMessage("\u5c01\u9762\u5df2\u901a\u8fc7\u5ba1\u6838\uff0c\u4e0d\u80fd\u518d\u4fee\u6539\u72b6\u6001");
        }
        if (Objects.equals(userCover.getStatus(), param.getStatus())) {
            return Message.build((boolean)false).setMessage("\u8f93\u5165\u72b6\u6001\u9519\u8bef");
        }
        userCover.setStatus(param.getStatus());
        userCover.setRemark(param.getRemake());
        userCover.setModifyTime(new Date());
        this.userCoverMapper.updateByPrimaryKeySelective(userCover);
        if (Objects.equals(param.getStatus(), UserCoverStatusEnum.AUDIT_PASS.getStatus())) {
            UserCoverDTO userCoverDTO = new UserCoverDTO();
            userCoverDTO.setUserId(userCover.getUserId());
            userCoverDTO.setAuditCover(userCover.getCoverUrl());
            userCoverDTO.setNoAuditCover(null);
            this.redisStringAdapter.set(this.userCoverCache(userCover.getUserId()), (Object)userCoverDTO);
        } else {
            PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.OPEN_URL);
            info.setProtocol("egg://mine/userHomePage?userId=" + userCover.getUserId() + "&toast=0");
            PushMessage message = PushMessage.build();
            message.setTitle("\u5c01\u9762\u5ba1\u6838\u5931\u8d25");
            message.setContent("\u7ecf\u4e3e\u62a5\u548c\u5ba1\u6838\uff0c\u4f60\u7684\u5c01\u9762\u56fe\u7247\u8fdd\u53cd\u86cb\u86cb\u4f73\u7ba1\u7406\u89c4\u8303\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\uff0c\u611f\u8c22\u4f60\u7684\u7406\u89e3");
            message.setType(TemplateTypeEnum.NOTIFCTION);
            message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userCover.getUserId()));
            message.setPayloadInfo(info);
            this.messageSender.sendPushMessage(message);
            UserCover auditSuccess = this.userCoverMapper.getLastCoverInfoByStatus(userCover.getUserId(), Integer.valueOf(1));
            UserCoverDTO userCoverDTO = new UserCoverDTO();
            userCoverDTO.setUserId(userCover.getUserId());
            if (Objects.nonNull(auditSuccess)) {
                userCoverDTO.setAuditCover(auditSuccess.getCoverUrl());
            }
            userCoverDTO.setNoAuditCover(null);
            this.redisStringAdapter.set(this.userCoverCache(userCover.getUserId()), (Object)userCoverDTO);
        }
        return Message.build((boolean)true);
    }

    @Override
    public IPageModel<UserCoverListDTO> getUserCoverList(UserCoverListParam param) {
        Page queryParam = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue());
        IPage userCovers = this.userCoverMapper.getUserCoverList((IPage)queryParam, param);
        List userCoverListDTOS = userCovers.getRecords().stream().map(this::toUserCoverListDTO).collect(Collectors.toList());
        PlusPageModelDTO resultList = PlusPageModelDTO.build((IPage)userCovers);
        resultList.changeList(userCoverListDTOS);
        return resultList;
    }

    private UserCoverListDTO toUserCoverListDTO(UserCover userCover) {
        UserCoverListDTO userCoverListDTO = new UserCoverListDTO();
        userCoverListDTO.setAddTime(userCover.getCreateTime());
        userCoverListDTO.setId(userCover.getId());
        userCoverListDTO.setNickname(userCover.getNickname());
        userCoverListDTO.setStatus(userCover.getStatus());
        userCoverListDTO.setUserId(userCover.getUserId());
        userCoverListDTO.setUrl(userCover.getCoverUrl());
        return userCoverListDTO;
    }

    @Autowired
    public UserCoverServiceImpl(RedisStringAdapter redisStringAdapter, UserWarmLevelService userWarmLevelService, UserCoverMapper userCoverMapper, MessageFacadeIntegrationService messageSender) {
        this.redisStringAdapter = redisStringAdapter;
        this.userWarmLevelService = userWarmLevelService;
        this.userCoverMapper = userCoverMapper;
        this.messageSender = messageSender;
    }
}

