/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.info.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.common.enums.UserStatusEnum;
import com.bxm.egg.user.constant.BaseCacheKeyConfig;
import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.equitylevelmedal.UserEquityLevelMedalService;
import com.bxm.egg.user.info.UserInfoCacheService;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.info.UserInformationService;
import com.bxm.egg.user.location.UserLocationService;
import com.bxm.egg.user.model.bo.UserCacheInfoBO;
import com.bxm.egg.user.model.bo.UserInformationBO;
import com.bxm.egg.user.model.bo.UserLocationBO;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.entity.UserInformationEntity;
import com.bxm.egg.user.model.entity.UserLocationEntity;
import com.bxm.egg.user.model.equitylevelmedal.UserEquityLevelMedalInfoDTO;
import com.bxm.egg.user.properties.HomePageConfigProperties;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.sync.core.CacheHolder;
import com.bxm.newidea.component.sync.core.SyncCacheHolderFactory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserInfoCacheServiceImpl
implements UserInfoCacheService {
    private static final Logger log = LoggerFactory.getLogger(UserInfoCacheServiceImpl.class);
    @Resource
    private UserInfoService userInfoService;
    @Resource
    private UserLocationService userLocationService;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private UserInformationService userInformationService;
    @Resource
    private UserEquityLevelMedalService userEquityLevelMedalService;
    @Resource
    private UserProperties userProperties;
    @Resource
    private HomePageConfigProperties homePageConfigProperties;

    private CacheHolder getCacheHolder() {
        return SyncCacheHolderFactory.builder().duration(30L).timeUnit(TimeUnit.MINUTES).keyGenerator(BaseCacheKeyConfig.USER_INFO_CACHE_KEY).cacheLoader(this::getUserInfoFromRedisOrDB).build();
    }

    @Override
    public UserCacheInfoBO load(Long userId) {
        return (UserCacheInfoBO)this.getCacheHolder().get(BaseCacheKeyConfig.USER_INFO_CACHE_KEY, (Object)userId);
    }

    @Override
    public List<UserCacheInfoBO> getBatchUserInfo(Collection<Long> userIds) {
        ArrayList userInfos = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(userIds)) {
            userIds.forEach(userId -> {
                UserCacheInfoBO userInfoBO = this.load((Long)userId);
                if (null != userInfoBO) {
                    userInfos.add(userInfoBO);
                }
            });
        }
        return userInfos;
    }

    @Override
    public void clearUserCache(Long userId) {
        this.getCacheHolder().evict(BaseCacheKeyConfig.USER_INFO_CACHE_KEY, (Object[])new Long[]{userId});
        this.redisStringAdapter.remove(this.buildUserKey(userId));
    }

    public UserCacheInfoBO getUserInfoFromRedisOrDB(Long userId) {
        UserCacheInfoBO userCacheInfo = this.getUserInfoFromRedis(userId);
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)userCacheInfo));
        }
        if (null == userCacheInfo || userCacheInfo.getUserId() == -1L) {
            return this.buildInvalidUserCacheInfo(userId);
        }
        return userCacheInfo;
    }

    public UserCacheInfoBO getUserInfoFromRedis(Long userId) {
        UserCacheInfoBO userCacheInfoBO = (UserCacheInfoBO)this.redisStringAdapter.get(RedisConfig.USER_INFO_CACHE_KEY, UserCacheInfoBO.class);
        if (userCacheInfoBO != null) {
            return userCacheInfoBO;
        }
        userCacheInfoBO = this.getUserInfoFromDB(userId);
        if (userCacheInfoBO == null) {
            UserCacheInfoBO invalidUserInfo = new UserCacheInfoBO();
            invalidUserInfo.setUserId(Long.valueOf(-1L));
            log.warn("\u52a0\u8f7d\u4e0d\u5b58\u5728\u7684\u7528\u6237,\u7528\u6237id:{}", (Object)userId);
            this.redisStringAdapter.set(this.buildUserKey(userId), (Object)invalidUserInfo, this.userProperties.getUserCacheExpiredSeconds().longValue());
            return invalidUserInfo;
        }
        this.redisStringAdapter.set(this.buildUserKey(userId), (Object)userCacheInfoBO, this.userProperties.getUserCacheExpiredSeconds().longValue());
        return userCacheInfoBO;
    }

    public UserCacheInfoBO getUserInfoFromDB(Long userId) {
        UserInfoEntity userInfoEntity = this.userInfoService.selectAllUserById(userId);
        if (userInfoEntity == null) {
            return null;
        }
        UserCacheInfoBO userCacheInfoBO = new UserCacheInfoBO();
        userCacheInfoBO.setUserId(userId);
        this.fillUserInfo(userCacheInfoBO, userInfoEntity);
        this.fillUserInformationInfo(userCacheInfoBO);
        this.fillUserLocationInfo(userCacheInfoBO);
        this.fillUserMedalInfoAndLevel(userCacheInfoBO);
        return userCacheInfoBO;
    }

    private void fillUserInfo(UserCacheInfoBO userCacheInfoBO, UserInfoEntity userInfoEntity) {
        BeanUtils.copyProperties((Object)userInfoEntity, (Object)userCacheInfoBO);
        userCacheInfoBO.setUserId(userInfoEntity.getId());
    }

    private void fillUserMedalInfoAndLevel(UserCacheInfoBO userCacheInfoBO) {
        UserEquityLevelMedalInfoDTO equityLevelMedalInfo = this.userEquityLevelMedalService.getEquityLevelMedalInfo(userCacheInfoBO.getUserId());
        if (equityLevelMedalInfo == null) {
            return;
        }
        userCacheInfoBO.setWearMedalList(equityLevelMedalInfo.getWearMedalDTOList());
        userCacheInfoBO.setUserWarmLevelDTO(equityLevelMedalInfo.getUserEquityDTO());
    }

    private void fillUserLocationInfo(UserCacheInfoBO userCacheInfoBO) {
        UserLocationEntity userLocationEntity = this.userLocationService.getUserLocationByUserId(userCacheInfoBO.getUserId());
        if (userLocationEntity == null) {
            return;
        }
        UserLocationBO userLocationBO = new UserLocationBO();
        userLocationBO.setLocationCode(userLocationEntity.getLocationCode());
        userLocationBO.setLocationName(userLocationEntity.getLocationName());
        userCacheInfoBO.setUserLocationBO(userLocationBO);
    }

    private void fillUserInformationInfo(UserCacheInfoBO userCacheInfoBO) {
        UserInformationEntity userInformationEntity = this.userInformationService.getUserInformationByUserId(userCacheInfoBO.getUserId());
        if (userInformationEntity == null) {
            return;
        }
        UserInformationBO userInformationBO = new UserInformationBO();
        userInformationBO.setPersonalProfile(userInformationEntity.getPersonalProfile());
        userInformationBO.setBirthday(userInformationEntity.getBirthday());
        if (StringUtils.isNotEmpty((CharSequence)userInformationBO.getPersonalProfile())) {
            userInformationBO.setIsDefaultPersonalProfile(Boolean.FALSE);
        } else {
            userInformationBO.setIsDefaultPersonalProfile(Boolean.TRUE);
            userInformationBO.setPersonalProfile(this.homePageConfigProperties.getDefaultPersonalProfile());
        }
        userCacheInfoBO.setUserInformationBO(userInformationBO);
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237\u8d44\u6599\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)userInformationBO));
        }
    }

    private UserCacheInfoBO buildInvalidUserCacheInfo(Long userId) {
        UserCacheInfoBO userCacheInfoBO = new UserCacheInfoBO();
        userCacheInfoBO.setHeadImg(this.userProperties.getDefaultHeadImageUrl());
        userCacheInfoBO.setUserId(userId);
        userCacheInfoBO.setNickname("\u672a\u77e5\u7528\u6237");
        userCacheInfoBO.setState(Integer.valueOf(UserStatusEnum.DISABLE.getCode()));
        return userCacheInfoBO;
    }

    private KeyGenerator buildUserKey(Long userId) {
        return RedisConfig.USER_INFO_CACHE_KEY.copy().appendKey((Object)userId);
    }
}

