/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.info.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.egg.user.info.UserInformationService;
import com.bxm.egg.user.mapper.UserInformationMapper;
import com.bxm.egg.user.model.entity.UserInformationEntity;
import java.time.LocalDateTime;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserInformationServiceImpl
implements UserInformationService {
    private static final Logger log = LoggerFactory.getLogger(UserInformationServiceImpl.class);
    private final UserInformationMapper userInformationMapper;

    @Override
    public UserInformationEntity getUserInformationByUserId(Long userId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserInformationEntity::getUserId, (Object)userId);
        UserInformationEntity userInformationEntity = (UserInformationEntity)this.userInformationMapper.selectOne((Wrapper)queryWrapper);
        if (userInformationEntity == null) {
            return this.buildDefaultInvalidInformation(userId);
        }
        return userInformationEntity;
    }

    private UserInformationEntity buildDefaultInvalidInformation(Long userId) {
        UserInformationEntity userInformationEntity = new UserInformationEntity();
        userInformationEntity.setId(Long.valueOf(0L));
        userInformationEntity.setUserId(userId);
        userInformationEntity.setJobTitle("");
        userInformationEntity.setPersonalProfile("\u8fd9\u4e2a\u4eba\u5f88\u61d2\uff0c\u4ec0\u4e48\u4e5f\u6ca1\u7559\u4e0b~");
        userInformationEntity.setInfoCompleteState(Long.valueOf(0L));
        userInformationEntity.setCreateTime(LocalDateTime.now());
        userInformationEntity.setModifyTime(LocalDateTime.now());
        return userInformationEntity;
    }

    @Override
    public int updateUserBirthday(Long userId, Date birthday) {
        UserInformationEntity updateUserInformationEntity = new UserInformationEntity();
        updateUserInformationEntity.setUserId(userId);
        updateUserInformationEntity.setBirthday(birthday);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserInformationEntity::getUserId, (Object)userId);
        return this.userInformationMapper.update((Object)updateUserInformationEntity, (Wrapper)queryWrapper);
    }

    @Override
    public int updateBackgroundImgUrlByUserId(Long userId, String backgroundImgUrl) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserInformationEntity::getUserId, (Object)userId);
        UserInformationEntity updateUserInformationEntity = new UserInformationEntity();
        updateUserInformationEntity.setUserId(userId);
        updateUserInformationEntity.setBackgroundImgUrl(backgroundImgUrl);
        return this.userInformationMapper.update((Object)updateUserInformationEntity, (Wrapper)queryWrapper);
    }

    public UserInformationServiceImpl(UserInformationMapper userInformationMapper) {
        this.userInformationMapper = userInformationMapper;
    }
}

