/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.info.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.egg.user.facade.param.UserStatisticsOperateParam;
import com.bxm.egg.user.info.UserStatisticsService;
import com.bxm.egg.user.mapper.UserStatisticsMapper;
import com.bxm.egg.user.model.entity.UserStatisticsEntity;
import com.bxm.newidea.component.bo.Message;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserStatisticsServiceImpl
implements UserStatisticsService {
    private static final Logger log = LoggerFactory.getLogger(UserStatisticsServiceImpl.class);
    private final UserStatisticsMapper userStatisticsMapper;

    @Override
    public UserStatisticsEntity selectUserStatisticsByUserId(Long userId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserStatisticsEntity::getUserId, (Object)userId);
        UserStatisticsEntity userStatisticsEntity = (UserStatisticsEntity)this.userStatisticsMapper.selectOne((Wrapper)queryWrapper);
        if (userStatisticsEntity == null) {
            return this.buildValidUserStatistics(userId);
        }
        return userStatisticsEntity;
    }

    private UserStatisticsEntity buildValidUserStatistics(Long userId) {
        UserStatisticsEntity userStatisticsEntity = new UserStatisticsEntity();
        userStatisticsEntity.setId(Long.valueOf(0L));
        userStatisticsEntity.setUserId(userId);
        userStatisticsEntity.setPostNum(Integer.valueOf(0));
        userStatisticsEntity.setReplyNum(Integer.valueOf(0));
        userStatisticsEntity.setAttentionNum(Integer.valueOf(0));
        userStatisticsEntity.setFanNum(Integer.valueOf(0));
        userStatisticsEntity.setLikeNum(Integer.valueOf(0));
        userStatisticsEntity.setSignNum(Integer.valueOf(0));
        userStatisticsEntity.setMaxSignNum(Integer.valueOf(0));
        userStatisticsEntity.setWarmValue(Integer.valueOf(0));
        userStatisticsEntity.setCreateTime(LocalDateTime.now());
        userStatisticsEntity.setModifyTime(LocalDateTime.now());
        return userStatisticsEntity;
    }

    @Override
    public int updateUserWarmInfo(Long userId, Integer warmValue, Integer defaultWarmValue) {
        return this.userStatisticsMapper.updateUserWarmInfo(userId, warmValue, defaultWarmValue);
    }

    @Override
    public Message operateUserStatistics(UserStatisticsOperateParam param) {
        int result = this.userStatisticsMapper.operateUserStatistics(param.getUserId(), Integer.valueOf(param.getUserStatisticsType().getCode()), Integer.valueOf(param.getOperateTypeEnum().getCode()), param.getOperateNum());
        if (result > 0) {
            return Message.build((boolean)true);
        }
        return Message.build((boolean)false, (String)"\u66f4\u65b0\u5931\u8d25");
    }

    public UserStatisticsServiceImpl(UserStatisticsMapper userStatisticsMapper) {
        this.userStatisticsMapper = userStatisticsMapper;
    }
}

