/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.invite.bind;

import com.bxm.egg.user.enums.InviteBindMethodEnum;
import com.bxm.egg.user.invite.bind.AbstractBindInviteStrategy;
import com.bxm.egg.user.invite.bind.DefaultBindMethod;
import com.bxm.egg.user.model.dto.UserInviteBindDTO;
import com.bxm.egg.user.model.vo.UserInviteHistoryBean;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BindInviteManager {
    private HashMap<InviteBindMethodEnum, AbstractBindInviteStrategy> inviteStrategyHashMap = new HashMap();
    private DefaultBindMethod defaultBindMethod;

    @Autowired
    public BindInviteManager(List<AbstractBindInviteStrategy> listStrategy, DefaultBindMethod defaultBindMethod) {
        if (!CollectionUtils.isEmpty(listStrategy)) {
            listStrategy.forEach(abstractBindInviteStrategy -> this.inviteStrategyHashMap.put(abstractBindInviteStrategy.getBindMethod(), (AbstractBindInviteStrategy)abstractBindInviteStrategy));
        }
        this.defaultBindMethod = defaultBindMethod;
    }

    public UserInviteHistoryBean bindInvite(UserInviteBindDTO userInviteBindDTO) {
        return this.inviteStrategyHashMap.getOrDefault(userInviteBindDTO.getInviteBindMethodEnum(), this.defaultBindMethod).doBindInvite(userInviteBindDTO);
    }
}

