/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.invite.egg.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.component.mybatis.dto.PlusPageModelDTO;
import com.bxm.egg.user.integration.sync.SixEnjoyInviteFoodsIntegrationService;
import com.bxm.egg.user.invite.egg.UserEggInviteService;
import com.bxm.egg.user.mapper.EggInviteMapper;
import com.bxm.egg.user.model.dto.invite.egg.InviteUserListDTO;
import com.bxm.egg.user.model.entity.EggInviteEntity;
import com.bxm.egg.user.model.param.invite.egg.InvitePageParam;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.newidea.component.dto.IPageModel;
import com.bxm.sync.facade.dto.InviteFoodsDTO;
import com.bxm.sync.facade.param.InviteFoodsParam;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class UserEggInviteServiceImpl
implements UserEggInviteService {
    private static final Logger log = LoggerFactory.getLogger(UserEggInviteServiceImpl.class);
    @Resource
    private EggInviteMapper eggInviteMapper;
    @Resource
    private UserProperties userProperties;
    @Resource
    private final SixEnjoyInviteFoodsIntegrationService sixEnjoyInviteFoodsIntegrationService;

    @Override
    public IPageModel<InviteUserListDTO> inviteList(InvitePageParam invitePageParam) {
        InviteFoodsParam inviteFoodsParam = new InviteFoodsParam();
        BeanUtils.copyProperties((Object)invitePageParam, (Object)inviteFoodsParam);
        List todayContributionList = this.sixEnjoyInviteFoodsIntegrationService.getTodayContribution(inviteFoodsParam);
        List resultList = todayContributionList.stream().map(this::convertToInviteUserListDTO).collect(Collectors.toList());
        Page page = new Page((long)invitePageParam.getPageNum().intValue(), (long)inviteFoodsParam.getPageNum().intValue());
        page.setRecords(resultList);
        return PlusPageModelDTO.build((IPage)page);
    }

    private InviteUserListDTO convertToInviteUserListDTO(InviteFoodsDTO item) {
        InviteUserListDTO userListDTO = new InviteUserListDTO();
        userListDTO.setUserId(item.getUserId());
        userListDTO.setNickName(item.getNickname());
        userListDTO.setTodayContributeFoodsNum(item.getFoodsNum());
        userListDTO.setHasEggNum(item.getEggNum());
        userListDTO.setHeadImg(item.getHeadImg());
        return userListDTO;
    }

    @Override
    public Long getInviteUserId(Long userId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(EggInviteEntity::getBeInviteUserId, (Object)userId);
        EggInviteEntity eggInviteEntity = (EggInviteEntity)this.eggInviteMapper.selectOne((Wrapper)queryWrapper);
        if (eggInviteEntity != null) {
            return eggInviteEntity.getUserId();
        }
        return null;
    }

    @Override
    public int countInviteUser(Long userId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(EggInviteEntity::getUserId, (Object)userId);
        return this.eggInviteMapper.selectCount((Wrapper)queryWrapper);
    }

    @Override
    public List<String> getUserInviteHeadImgList(Long userId) {
        return this.eggInviteMapper.getInviteUserHeadImg(userId, this.userProperties.getInviteHeadImgNum().intValue());
    }

    public UserEggInviteServiceImpl(EggInviteMapper eggInviteMapper, UserProperties userProperties, SixEnjoyInviteFoodsIntegrationService sixEnjoyInviteFoodsIntegrationService) {
        this.eggInviteMapper = eggInviteMapper;
        this.userProperties = userProperties;
        this.sixEnjoyInviteFoodsIntegrationService = sixEnjoyInviteFoodsIntegrationService;
    }
}

