/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.invite.processor;

import com.bxm.egg.common.constant.InviteTypeEnum;
import com.bxm.egg.user.dto.TopicFacadeVO;
import com.bxm.egg.user.integration.NewsIntegrationService;
import com.bxm.egg.user.invite.InviteProcessorContext;
import com.bxm.egg.user.invite.processor.AbstractInviteTypeProcessor;
import com.bxm.egg.user.model.vo.UserInviteHistoryBean;
import com.bxm.egg.user.utils.MaxLengthStringBuilder;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TopicInviteTypeProcessor
extends AbstractInviteTypeProcessor {
    private final NewsIntegrationService newsIntegrationService;

    @Autowired
    public TopicInviteTypeProcessor(NewsIntegrationService newsIntegrationService) {
        this.newsIntegrationService = newsIntegrationService;
    }

    @Override
    public String obtainTitle(InviteProcessorContext context) {
        if (context.getRelationId() == null) {
            return "";
        }
        TopicFacadeVO topic = this.newsIntegrationService.getTopicById(context.getRelationId());
        if (StringUtils.isBlank((CharSequence)topic.getTitle())) {
            return "";
        }
        return topic.getTitle();
    }

    @Override
    Message callback(InviteProcessorContext context) {
        return null;
    }

    @Override
    public InviteTypeEnum support() {
        return InviteTypeEnum.TOPIC;
    }

    @Override
    public String decorateTitle(UserInviteHistoryBean inviteHistory) {
        if (StringUtils.isBlank((CharSequence)inviteHistory.getRelationTitle())) {
            return this.defaultInviteMsg;
        }
        return MaxLengthStringBuilder.builder(this.defaultColumnWidth).appendImmutable("\u5206\u4eab\u7684\u300a").appendDynamic(inviteHistory.getRelationTitle()).appendImmutable("\u300b\u8bdd\u9898").build();
    }
}

