/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.location.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.user.dto.LocationDTO;
import com.bxm.egg.user.event.ActiveActionEvent;
import com.bxm.egg.user.event.LocationActionEvent;
import com.bxm.egg.user.event.UserActionEvent;
import com.bxm.egg.user.info.UserStatisticsService;
import com.bxm.egg.user.integration.LocationIntegrationService;
import com.bxm.egg.user.integration.UserSyncIntegrationService;
import com.bxm.egg.user.location.UserInternalService;
import com.bxm.egg.user.location.UserLocationService;
import com.bxm.egg.user.login.UserParamCheckService;
import com.bxm.egg.user.mapper.UserLocationHistoryMapper;
import com.bxm.egg.user.model.entity.UserLocationEntity;
import com.bxm.egg.user.model.entity.UserStatisticsEntity;
import com.bxm.egg.user.model.param.ChangeLocationParam;
import com.bxm.egg.user.model.param.UserLocationParam;
import com.bxm.egg.user.model.vo.UserLocationHistory;
import com.bxm.egg.user.properties.CommonProperties;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.google.common.eventbus.EventBus;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class UserInternalServiceImpl
implements UserInternalService {
    private static final Logger log = LoggerFactory.getLogger(UserInternalServiceImpl.class);
    private UserLocationHistoryMapper userLocationHistoryMapper;
    private LocationIntegrationService locationIntegrationService;
    private CommonProperties commonProperties;
    private UserParamCheckService userParamCheckService;
    private UserLocationService userLocationService;
    private EventBus userActionEventBus;
    private UserSyncIntegrationService userSyncIntegrationService;
    private UserStatisticsService userStatisticsService;

    @Override
    public LocationDTO doPostingLocation(ChangeLocationParam changeLocationParam, String ip) {
        Message message = this.userParamCheckService.checkPostLocationParam(changeLocationParam.getCode(), changeLocationParam.getUserId());
        if (!message.isSuccess()) {
            log.error(message.getLastMessage());
        }
        if (null == changeLocationParam.getCode()) {
            changeLocationParam.setCode(this.commonProperties.getLocationCode());
        }
        LocationDTO locationDTO = this.locationIntegrationService.getLocationByGeocode(changeLocationParam.getCode());
        if (null != changeLocationParam.getUserId()) {
            UserStatisticsEntity userStatisticsEntity = this.userStatisticsService.selectUserStatisticsByUserId(changeLocationParam.getUserId());
            locationDTO.setPublishPostNum(Integer.valueOf(userStatisticsEntity == null ? 0 : userStatisticsEntity.getPostNum()));
            this.afterPostingLocation(locationDTO, changeLocationParam, ip);
        } else {
            locationDTO.setPublishPostNum(Integer.valueOf(0));
        }
        return locationDTO;
    }

    @Async
    public void afterPostingLocation(LocationDTO locationDTO, ChangeLocationParam changeLocationParam, String ip) {
        Long userId = changeLocationParam.getUserId();
        UserLocationEntity userLocationInfo = this.userLocationService.getUserLocationByUserId(userId);
        if (null != userLocationInfo && com.bxm.newidea.component.tools.StringUtils.notEquals((CharSequence)userLocationInfo.getLocationCode(), (CharSequence)locationDTO.getCode())) {
            String oldLocationCode = userLocationInfo.getLocationCode();
            userLocationInfo.setLocationCode(locationDTO.getCode());
            userLocationInfo.setLocationName(locationDTO.getName());
            this.userLocationService.updateUserLocationInfo(userId, locationDTO.getCode(), locationDTO.getName());
            UserLocationHistory userLocationHistory = new UserLocationHistory();
            userLocationHistory.setAddTime(new Date());
            userLocationHistory.setId(SequenceHolder.nextLongId());
            userLocationHistory.setLocationCode(locationDTO.getCode());
            userLocationHistory.setUserId(userId);
            this.userLocationHistoryMapper.insert(userLocationHistory);
            this.userSyncIntegrationService.changeLocation(userId, changeLocationParam.getCode());
            if (StringUtils.isNotBlank((CharSequence)locationDTO.getCode())) {
                UserActionEvent userActionEvent = LocationActionEvent.of().setLocationCode(locationDTO.getCode()).setLocationName(locationDTO.getName()).setOldLocationCode(oldLocationCode).setUserId(userId);
                this.userActionEventBus.post((Object)userActionEvent);
            }
        } else if (null != userLocationInfo) {
            log.warn("\u7528\u6237\u4f4d\u7f6e\u4fe1\u606f\u53d8\u66f4\u5931\u8d25\uff0c\u7528\u6237ID\uff1a{},\u53d8\u66f4\u540e\u7684\u4f4d\u7f6e:{},\u7528\u6237\u7684\u5f53\u524d\u4f4d\u7f6e\uff1a{}", new Object[]{userId, locationDTO.getCode(), userLocationInfo.getLocationCode()});
        }
    }

    @Override
    public Boolean postUserPositionAndLoginInfo(UserLocationParam userLocationParam) {
        if (log.isDebugEnabled()) {
            log.debug("\u4e0a\u62a5\u7528\u6237\u5b9a\u4f4d\u4ee5\u53ca\u6d3b\u8dc3\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)userLocationParam));
        }
        LocationDTO locationByGeocode = this.locationIntegrationService.getLocationByGeocode(userLocationParam.getCurrentAreaCode());
        UserActionEvent userActionEvent = ActiveActionEvent.of().setLastLoginTime(new Date()).setLongitude(userLocationParam.getLongitude()).setLatitude(userLocationParam.getLatitude()).setCurrentAreaCode(locationByGeocode.getCode()).setUserId(userLocationParam.getUserId());
        this.userActionEventBus.post((Object)userActionEvent);
        return true;
    }

    @Autowired
    public UserInternalServiceImpl(UserLocationHistoryMapper userLocationHistoryMapper, LocationIntegrationService locationIntegrationService, CommonProperties commonProperties, UserParamCheckService userParamCheckService, UserLocationService userLocationService, EventBus userActionEventBus, UserSyncIntegrationService userSyncIntegrationService, UserStatisticsService userStatisticsService) {
        this.userLocationHistoryMapper = userLocationHistoryMapper;
        this.locationIntegrationService = locationIntegrationService;
        this.commonProperties = commonProperties;
        this.userParamCheckService = userParamCheckService;
        this.userLocationService = userLocationService;
        this.userActionEventBus = userActionEventBus;
        this.userSyncIntegrationService = userSyncIntegrationService;
        this.userStatisticsService = userStatisticsService;
    }
}

