/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.login.impl;

import com.bxm.egg.user.constant.UserLoginTypeEnum;
import com.bxm.egg.user.login.UserLogService;
import com.bxm.egg.user.mapper.UserLoginHistoryMapper;
import com.bxm.egg.user.mapper.UserRegisterLogMapper;
import com.bxm.egg.user.model.dto.login.LoginResultDTO;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.entity.UserLoginHistoryEntity;
import com.bxm.egg.user.model.entity.UserRegisterLogEntity;
import com.bxm.egg.user.model.param.login.LoginParam;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class UserLogServiceImpl
implements UserLogService {
    private static final Logger log = LoggerFactory.getLogger(UserLogServiceImpl.class);
    @Resource
    private UserRegisterLogMapper userRegisterLogMapper;
    @Resource
    private SequenceCreater sequenceCreater;
    @Resource
    private UserLoginHistoryMapper loginHistoryMapper;

    @Override
    @Async
    public void recordRegisterLog(UserInfoEntity newUser, LoginParam param) {
        UserRegisterLogEntity userRegisterLogEntity = new UserRegisterLogEntity();
        userRegisterLogEntity.setChannel(param.getChnl());
        userRegisterLogEntity.setId(this.sequenceCreater.nextLongId());
        userRegisterLogEntity.setLoginIp(param.getRequestIp());
        userRegisterLogEntity.setPlatform(param.getPlatform());
        userRegisterLogEntity.setUserId(newUser.getId());
        this.userRegisterLogMapper.insert((Object)userRegisterLogEntity);
    }

    @Override
    @Async
    public void recordLoginLog(LoginParam loginParam, LoginResultDTO resultDTO, UserLoginTypeEnum userLoginTypeEnum) {
        UserLoginHistoryEntity userLoginHistoryEntity = new UserLoginHistoryEntity();
        userLoginHistoryEntity.setId(this.sequenceCreater.nextLongId());
        userLoginHistoryEntity.setUserId(resultDTO.getUserId());
        userLoginHistoryEntity.setLoginType(userLoginTypeEnum.name());
        userLoginHistoryEntity.setLoginIp(loginParam.getRequestIp());
        userLoginHistoryEntity.setEquipmentId(loginParam.getDevcId());
        userLoginHistoryEntity.setFirstLogin(Integer.valueOf(resultDTO.getFirstLogin() != false ? 1 : 0));
        userLoginHistoryEntity.setLoginTime(LocalDateTime.now());
        userLoginHistoryEntity.setPlatform(loginParam.getPlatform());
        userLoginHistoryEntity.setClientChannel(loginParam.getChnl());
        this.loginHistoryMapper.insert((Object)userLoginHistoryEntity);
    }
}

