/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.medal.impl;

import com.bxm.egg.user.enums.MedalCategoryEnum;
import com.bxm.egg.user.enums.UserAchievementMedalStatusEnum;
import com.bxm.egg.user.enums.WarmValueEquityEnum;
import com.bxm.egg.user.info.UserInfoCacheService;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.info.msg.UserInfoChangeSender;
import com.bxm.egg.user.mapper.medal.UserMedalRelationInfoMapper;
import com.bxm.egg.user.medal.UserMedalService;
import com.bxm.egg.user.medal.cache.AchievementMedalCacheManager;
import com.bxm.egg.user.model.bo.UserCacheInfoBO;
import com.bxm.egg.user.model.dto.medal.MainPageMedalImageDTO;
import com.bxm.egg.user.model.dto.medal.MedalMainPageSimpleDTO;
import com.bxm.egg.user.model.dto.warmlevel.UserWarmLevelInfoDTO;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.entity.medal.UserMedalInfoEntity;
import com.bxm.egg.user.model.entity.medal.UserMedalRelationInfoEntity;
import com.bxm.egg.user.model.param.medal.SaveWearMedalParam;
import com.bxm.egg.user.model.vo.medal.AchievementMedalDetailVO;
import com.bxm.egg.user.model.vo.medal.CustomMedalDetailVO;
import com.bxm.egg.user.model.vo.medal.MedalLevelVO;
import com.bxm.egg.user.model.vo.medal.MyMedalVO;
import com.bxm.egg.user.model.vo.medal.OthersMedalVO;
import com.bxm.egg.user.model.vo.medal.PreviewMedalInfoVO;
import com.bxm.egg.user.model.vo.medal.SingleAchievementMedalBaseVO;
import com.bxm.egg.user.model.vo.medal.SingleCustomMedalBaseVO;
import com.bxm.egg.user.model.vo.medal.SinglePreviewMedalVO;
import com.bxm.egg.user.warmlevel.UserWarmLevelService;
import com.bxm.newidea.component.bo.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserMedalServiceImpl
implements UserMedalService {
    private static final Logger log = LoggerFactory.getLogger(UserMedalServiceImpl.class);
    private AchievementMedalCacheManager achievementMedalCacheManager;
    private UserMedalRelationInfoMapper userMedalRelationInfoMapper;
    private UserInfoService userInfoService;
    private UserWarmLevelService userWarmLevelService;
    private UserInfoCacheService userInfoCacheService;
    private UserInfoChangeSender userInfoChangeSender;

    @Override
    public OthersMedalVO getOthersMedal(Long othersUserId) {
        OthersMedalVO resultMedalVO = new OthersMedalVO();
        UserCacheInfoBO userCacheInfoBO = this.userInfoCacheService.load(othersUserId);
        resultMedalVO.setUserId(userCacheInfoBO.getUserId());
        resultMedalVO.setHeadImg(userCacheInfoBO.getHeadImg());
        resultMedalVO.setNickname(userCacheInfoBO.getNickname());
        resultMedalVO.setMedalNum(Integer.valueOf(this.getUserMedalNum(othersUserId)));
        List userAllAchievementMedalList = this.userMedalRelationInfoMapper.getUserMaxLevelAchievementMedal(othersUserId);
        List<Object> achievementMedalList = new ArrayList<SingleAchievementMedalBaseVO>();
        if (Boolean.FALSE.equals(CollectionUtils.isEmpty((Collection)userAllAchievementMedalList))) {
            for (UserMedalRelationInfoEntity userMedalRelationInfoEntity : userAllAchievementMedalList) {
                achievementMedalList.add(this.convert2SingleAchievementMedalBaseVO(userMedalRelationInfoEntity.getMedalId(), UserAchievementMedalStatusEnum.NOT_UP_LEVEL.getCode()));
            }
            achievementMedalList = achievementMedalList.stream().sorted(Comparator.comparing(SingleAchievementMedalBaseVO::getTOrder)).collect(Collectors.toList());
        }
        resultMedalVO.setAchievementMedalList(achievementMedalList);
        List otherUserCustomMedalInfoList = this.userMedalRelationInfoMapper.getOtherUserCustomMedalInfo(othersUserId);
        for (SingleCustomMedalBaseVO singleCustomMedalBaseVO : otherUserCustomMedalInfoList) {
            singleCustomMedalBaseVO.setExpired(Boolean.valueOf(false));
        }
        resultMedalVO.setCustomMedalList(otherUserCustomMedalInfoList);
        return resultMedalVO;
    }

    @Override
    public MyMedalVO getMyMedal(Long userId) {
        MyMedalVO resultMyMedalVO = new MyMedalVO();
        UserInfoEntity userInfoEntity = this.userInfoService.selectUserById(userId);
        resultMyMedalVO.setUserId(userInfoEntity.getId());
        resultMyMedalVO.setHeadImg(userInfoEntity.getHeadImg());
        resultMyMedalVO.setNickname(userInfoEntity.getNickname());
        resultMyMedalVO.setMedalNum(Integer.valueOf(this.getUserMedalNum(userId)));
        List<Object> achievementMedalList = new ArrayList();
        Map<Long, List<UserMedalInfoEntity>> medalParentId2InfoListMap = this.achievementMedalCacheManager.getMedalParentId2InfoListMap();
        List<Long> allMedalParentIdList = this.achievementMedalCacheManager.getAllMedalParentIdList();
        for (Long parentMedalId : allMedalParentIdList) {
            UserMedalRelationInfoEntity userMaxLevelMedalInfo = this.userMedalRelationInfoMapper.getUserMaxLevelMedalInfo(userId, parentMedalId);
            if (Objects.isNull(userMaxLevelMedalInfo)) {
                List<UserMedalInfoEntity> userMedalInfoEntityList = medalParentId2InfoListMap.get(parentMedalId);
                UserMedalInfoEntity minMedalInfoEntity = userMedalInfoEntityList.stream().min(Comparator.comparing(UserMedalInfoEntity::getLevel)).get();
                achievementMedalList.add(this.convert2SingleAchievementMedalBaseVO(minMedalInfoEntity.getId(), UserAchievementMedalStatusEnum.UN_LOCK.getCode()));
                continue;
            }
            achievementMedalList.add(this.convert2SingleAchievementMedalBaseVO(userMaxLevelMedalInfo.getMedalId(), this.achievementMedalCacheManager.isMaxLevel(parentMedalId, userMaxLevelMedalInfo.getMedalLevel()) ? UserAchievementMedalStatusEnum.NOT_UP_LEVEL.getCode() : UserAchievementMedalStatusEnum.WAIT_UP_LEVEL.getCode()));
        }
        achievementMedalList = achievementMedalList.stream().sorted(Comparator.comparing(SingleAchievementMedalBaseVO::getTOrder)).collect(Collectors.toList());
        resultMyMedalVO.setAchievementMedalList(achievementMedalList);
        List myUserCustomMedalList = this.userMedalRelationInfoMapper.getMyUserCustomMedalInfo(userId);
        Iterator iterator = myUserCustomMedalList.iterator();
        while (iterator.hasNext()) {
            SingleCustomMedalBaseVO singleCustomMedalBaseVO;
            singleCustomMedalBaseVO.setExpired(Boolean.valueOf((singleCustomMedalBaseVO = (SingleCustomMedalBaseVO)iterator.next()).getExpiredStatus() == 0));
        }
        resultMyMedalVO.setCustomMedalList(myUserCustomMedalList);
        return resultMyMedalVO;
    }

    @Override
    public AchievementMedalDetailVO getAchievementMedalDetail(Long medalParentId, Long userId) {
        AchievementMedalDetailVO resultVO = new AchievementMedalDetailVO();
        UserCacheInfoBO userCacheInfoBO = this.userInfoCacheService.load(userId);
        resultVO.setUserId(userCacheInfoBO.getUserId());
        resultVO.setHeadImg(userCacheInfoBO.getHeadImg());
        resultVO.setNickname(userCacheInfoBO.getNickname());
        resultVO.setMedalParentId(medalParentId);
        UserWarmLevelInfoDTO userWarmValueInfo = this.userWarmLevelService.getUserWarmValueInfo(userId);
        resultVO.setUserLevel(userWarmValueInfo.getLevel());
        resultVO.setUserLevelImg(userWarmValueInfo.getLevelUrl());
        UserMedalRelationInfoEntity maxLevelMedalInfo = this.userMedalRelationInfoMapper.getUserMaxLevelMedalInfo(userId, medalParentId);
        if (Objects.nonNull(maxLevelMedalInfo)) {
            resultVO.setCurrentLevel(maxLevelMedalInfo.getMedalLevel());
        } else {
            resultVO.setCurrentLevel(Integer.valueOf(0));
        }
        Map<Long, List<UserMedalInfoEntity>> medalParentId2InfoListMap = this.achievementMedalCacheManager.getMedalParentId2InfoListMap();
        List<UserMedalInfoEntity> userMedalInfoEntityList = medalParentId2InfoListMap.get(medalParentId);
        List<Object> medalLevelList = new ArrayList();
        for (UserMedalInfoEntity userMedalInfoEntity : userMedalInfoEntityList) {
            MedalLevelVO medalLevelVO = new MedalLevelVO();
            medalLevelVO.setMedalParentId(userMedalInfoEntity.getParentId());
            medalLevelVO.setMedalId(userMedalInfoEntity.getId());
            medalLevelVO.setMedalName(userMedalInfoEntity.getName());
            medalLevelVO.setLevel(userMedalInfoEntity.getLevel());
            medalLevelVO.setUnlockDesc(userMedalInfoEntity.getUnLockDesc());
            medalLevelVO.setExplainText(userMedalInfoEntity.getExplainText());
            medalLevelVO.setUpLevelDesc(userMedalInfoEntity.getUpLevelDesc());
            medalLevelVO.setDisplayIconUrl(userMedalInfoEntity.getGifImgUrl());
            medalLevelVO.setDisplayStaticIconUrl(userMedalInfoEntity.getActiveImgUrl());
            medalLevelVO.setDisplayLockIconUrl(userMedalInfoEntity.getLockImgUrl());
            medalLevelVO.setJumpUrl(userMedalInfoEntity.getJumpUrl());
            UserMedalRelationInfoEntity medalRecordInfo = this.userMedalRelationInfoMapper.getByUserIdAndMedalId(userId, userMedalInfoEntity.getId());
            if (Objects.nonNull(medalRecordInfo)) {
                medalLevelVO.setUnlock(Boolean.valueOf(true));
                medalLevelVO.setGrantDateTime(medalRecordInfo.getCreateTime());
            } else {
                medalLevelVO.setUnlock(Boolean.valueOf(false));
            }
            medalLevelList.add(medalLevelVO);
        }
        medalLevelList = medalLevelList.stream().sorted(Comparator.comparing(MedalLevelVO::getLevel)).collect(Collectors.toList());
        resultVO.setMedalLevelList(medalLevelList);
        return resultVO;
    }

    @Override
    public CustomMedalDetailVO getCustomMedalDetail(Long medalId, Long userId) {
        CustomMedalDetailVO customMedalDetail = this.userMedalRelationInfoMapper.getCustomMedalDetail(userId, medalId);
        UserInfoEntity userInfoEntity = this.userInfoService.selectUserById(userId);
        customMedalDetail.setUserId(userId);
        customMedalDetail.setNickname(userInfoEntity.getNickname());
        customMedalDetail.setHeadImg(userInfoEntity.getHeadImg());
        UserWarmLevelInfoDTO userWarmValueInfo = this.userWarmLevelService.getUserWarmValueInfo(userId);
        customMedalDetail.setUserLevel(userWarmValueInfo.getLevel());
        customMedalDetail.setUserLevelImg(userWarmValueInfo.getLevelUrl());
        return customMedalDetail;
    }

    @Override
    public PreviewMedalInfoVO getPreviewMedalInfo(Long userId) {
        PreviewMedalInfoVO resultVO = new PreviewMedalInfoVO();
        UserInfoEntity userInfoEntity = this.userInfoService.selectUserById(userId);
        resultVO.setUserId(userInfoEntity.getId());
        resultVO.setHeadImg(userInfoEntity.getHeadImg());
        resultVO.setNickname(userInfoEntity.getNickname());
        UserWarmLevelInfoDTO userWarmValueInfo = this.userWarmLevelService.getUserWarmValueInfo(userId);
        resultVO.setUserLevel(userWarmValueInfo.getLevel());
        resultVO.setLevelImgUrl(userWarmValueInfo.getLevelUrl());
        Map<Long, UserMedalInfoEntity> medalId2InfoMap = this.achievementMedalCacheManager.getMedalId2InfoMap();
        List userMaxLevelAchievementMedalList = this.userMedalRelationInfoMapper.getUserMaxLevelAchievementMedal(userId);
        List previewAchievementList = userMaxLevelAchievementMedalList.stream().map(achievementMedalRecord -> {
            SinglePreviewMedalVO item = new SinglePreviewMedalVO();
            UserMedalInfoEntity userMedalInfoEntity = (UserMedalInfoEntity)medalId2InfoMap.get(achievementMedalRecord.getMedalId());
            item.setMedalId(achievementMedalRecord.getMedalId());
            item.setLevel(userMedalInfoEntity.getLevel());
            item.setMedalImgUrl(userMedalInfoEntity.getActiveImgUrl());
            item.setMedalName(userMedalInfoEntity.getName());
            item.setThumbnailUrl(userMedalInfoEntity.getThumbnailUrl());
            item.setHasWear(achievementMedalRecord.getHasWear());
            item.setWearOrder(achievementMedalRecord.getWearOrder());
            item.setTOrder(userMedalInfoEntity.getTOrder());
            return item;
        }).sorted(Comparator.comparing(SinglePreviewMedalVO::getTOrder)).collect(Collectors.toList());
        List previewCustomList = this.userMedalRelationInfoMapper.getAllUsableCustomMedalInfo(userId);
        List userAllMedalList = new ArrayList();
        userAllMedalList.addAll(previewAchievementList);
        userAllMedalList.addAll(previewCustomList);
        userAllMedalList = userAllMedalList.stream().sorted(Comparator.comparing(SinglePreviewMedalVO::getHasWear, Comparator.reverseOrder()).thenComparing(SinglePreviewMedalVO::getWearOrder)).collect(Collectors.toList());
        List wearMedalInfo = this.userMedalRelationInfoMapper.getAllWearMedalInfo(userId);
        resultVO.setMyMedalList(userAllMedalList);
        resultVO.setSelectedMedalList(wearMedalInfo);
        return resultVO;
    }

    @Override
    public Message saveWearMedal(SaveWearMedalParam param) {
        UserWarmLevelInfoDTO userWarmInfoCache = this.userWarmLevelService.getUserWarmInfoCache(param.getUserId());
        String[] equityType = userWarmInfoCache.getEquityDTO().getEquityType();
        List<String> equityCodeList = Collections.EMPTY_LIST;
        if (Objects.nonNull(equityType) && equityType.length > 0) {
            equityCodeList = Arrays.asList(equityType);
        }
        if (Boolean.FALSE.equals(equityCodeList.contains(WarmValueEquityEnum.MEDAL_WEAR.name()))) {
            return Message.build((boolean)false, (String)"\u6682\u65f6\u65e0\u6cd5\u4f69\u6234\u52cb\u7ae0\uff0c\u63d0\u5347\u7b49\u7ea7\u5427\uff01");
        }
        List medalIdList = param.getMedalId();
        if (medalIdList.size() > 2) {
            medalIdList = medalIdList.subList(0, 2);
        }
        this.userMedalRelationInfoMapper.unWearUserMedal(param.getUserId());
        if (CollectionUtils.isEmpty(medalIdList)) {
            return Message.build((boolean)true);
        }
        for (int i = 0; i < medalIdList.size(); ++i) {
            this.userMedalRelationInfoMapper.wearMedal(param.getUserId(), (Long)medalIdList.get(i), Integer.valueOf(i + 1));
        }
        this.userInfoChangeSender.sendUserChangeMsg(param.getUserId());
        return Message.build((boolean)true);
    }

    @Override
    public MedalMainPageSimpleDTO getMainPageMedalDetail(Long userId) {
        MedalMainPageSimpleDTO resultDTO = new MedalMainPageSimpleDTO();
        resultDTO.setMedalNum(Integer.valueOf(this.getUserMedalNum(userId)));
        resultDTO.setMedalImgList(this.getMainPageMedalImgList(userId));
        return resultDTO;
    }

    private List<String> getMainPageMedalImgList(Long userId) {
        List userRelationList = this.userMedalRelationInfoMapper.getRelationListByUserId(userId);
        if (CollectionUtils.isEmpty((Collection)userRelationList)) {
            return Collections.emptyList();
        }
        Map<Integer, List<MainPageMedalImageDTO>> groupByUserMedalMap = userRelationList.stream().collect(Collectors.groupingBy(MainPageMedalImageDTO::getMedalCategory));
        List<MainPageMedalImageDTO> achievementMedalList = groupByUserMedalMap.get(MedalCategoryEnum.ACHIEVEMENT_MEDAL.getCode());
        List<MainPageMedalImageDTO> customMedalList = groupByUserMedalMap.get(MedalCategoryEnum.CUSTOM_MEDAL.getCode());
        ArrayList<MainPageMedalImageDTO> resultList = new ArrayList<MainPageMedalImageDTO>();
        if (CollectionUtils.isNotEmpty(customMedalList)) {
            resultList.addAll(customMedalList);
        }
        if (CollectionUtils.isNotEmpty(achievementMedalList)) {
            Map<Long, List<MainPageMedalImageDTO>> achievementMedalMap = achievementMedalList.stream().collect(Collectors.groupingBy(MainPageMedalImageDTO::getMedalParentId));
            achievementMedalMap.forEach((medalParentId, medalImageDTOList) -> {
                if (CollectionUtils.isNotEmpty((Collection)medalImageDTOList)) {
                    MainPageMedalImageDTO mainPageMedalImageDTO = medalImageDTOList.stream().max(Comparator.comparing(MainPageMedalImageDTO::getMedalLevel)).get();
                    resultList.add(mainPageMedalImageDTO);
                }
            });
        }
        return resultList.stream().sorted(Comparator.comparing(MainPageMedalImageDTO::getCreateTime).reversed()).map(MainPageMedalImageDTO::getDisplayImgUrl).limit(3L).collect(Collectors.toList());
    }

    @Override
    public int getUserMedalNum(Long userId) {
        int achievementMedalNum = this.userMedalRelationInfoMapper.countUserAchievementMedalNum(userId);
        int customMedalNum = this.userMedalRelationInfoMapper.countUserCustomMedalNum(userId);
        return achievementMedalNum + customMedalNum;
    }

    private SingleAchievementMedalBaseVO convert2SingleAchievementMedalBaseVO(Long medalId, Integer medalStatus) {
        SingleAchievementMedalBaseVO resultItem = new SingleAchievementMedalBaseVO();
        Map<Long, UserMedalInfoEntity> medalId2InfoMap = this.achievementMedalCacheManager.getMedalId2InfoMap();
        UserMedalInfoEntity userMedalInfoEntity = medalId2InfoMap.get(medalId);
        resultItem.setMedalId(medalId);
        resultItem.setMedalParentId(userMedalInfoEntity.getParentId());
        resultItem.setLevel(userMedalInfoEntity.getLevel());
        resultItem.setMedalImgUrl(UserAchievementMedalStatusEnum.UN_LOCK.getCode().equals(medalStatus) ? userMedalInfoEntity.getLockImgUrl() : userMedalInfoEntity.getActiveImgUrl());
        resultItem.setMedalName(userMedalInfoEntity.getName());
        resultItem.setStatus(medalStatus);
        resultItem.setTOrder(userMedalInfoEntity.getTOrder());
        return resultItem;
    }

    public UserMedalServiceImpl(AchievementMedalCacheManager achievementMedalCacheManager, UserMedalRelationInfoMapper userMedalRelationInfoMapper, UserInfoService userInfoService, UserWarmLevelService userWarmLevelService, UserInfoCacheService userInfoCacheService, UserInfoChangeSender userInfoChangeSender) {
        this.achievementMedalCacheManager = achievementMedalCacheManager;
        this.userMedalRelationInfoMapper = userMedalRelationInfoMapper;
        this.userInfoService = userInfoService;
        this.userWarmLevelService = userWarmLevelService;
        this.userInfoCacheService = userInfoCacheService;
        this.userInfoChangeSender = userInfoChangeSender;
    }
}

