/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.medal.strategy;

import com.bxm.egg.user.medal.strategy.AbstractMedalCounterStrategy;
import com.bxm.egg.user.model.dto.medal.UserMedalCounterDTO;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MedalCounterStrategyManager {
    private static final Logger log = LoggerFactory.getLogger(MedalCounterStrategyManager.class);
    private List<AbstractMedalCounterStrategy> medalCounterStrategyList;

    public void handleCounterData(UserMedalCounterDTO userMedalCounterDTO) {
        AbstractMedalCounterStrategy targetStrategy = this.matchStrategy(userMedalCounterDTO);
        if (Objects.nonNull(targetStrategy)) {
            targetStrategy.handleData(userMedalCounterDTO);
        }
    }

    private AbstractMedalCounterStrategy matchStrategy(UserMedalCounterDTO userMedalCounterDTO) {
        for (AbstractMedalCounterStrategy medalCounterStrategy : this.medalCounterStrategyList) {
            if (log.isDebugEnabled()) {
                log.debug("\u52cb\u7ae0\u4f20\u5165\u7c7b\u578b\uff1a{}, \u52cb\u7ae0\u5339\u914d\u7684\u7c7b\u578b\uff1a{}", (Object)userMedalCounterDTO.getOperatorType(), (Object)medalCounterStrategy.counterType());
            }
            if (!medalCounterStrategy.counterType().equals(userMedalCounterDTO.getOperatorType())) continue;
            return medalCounterStrategy;
        }
        log.error("\u672a\u5339\u914d\u5230\u52cb\u7ae0\u7edf\u8ba1\u6570\u636e\u5904\u7406\u7b56\u7565, ");
        return null;
    }

    public MedalCounterStrategyManager(List<AbstractMedalCounterStrategy> medalCounterStrategyList) {
        this.medalCounterStrategyList = medalCounterStrategyList;
    }
}

