/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.medal.strategy.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.user.account.UserAccountService;
import com.bxm.egg.user.enums.UserMedalCounterTypeEnum;
import com.bxm.egg.user.enums.UserMedalTypeEnum;
import com.bxm.egg.user.medal.strategy.AbstractMedalCounterStrategy;
import com.bxm.egg.user.model.dto.medal.MedalExtDataDTO;
import com.bxm.egg.user.model.dto.medal.UserMedalCounterDTO;
import com.bxm.egg.user.model.entity.UserAccountEntity;
import com.bxm.egg.user.model.entity.medal.UserMedalInfoEntity;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EggCounterStrategy
extends AbstractMedalCounterStrategy {
    private static final Logger log = LoggerFactory.getLogger(EggCounterStrategy.class);
    private UserAccountService userAccountService;

    @Override
    protected void handleCounterData(UserMedalCounterDTO userMedalCounterDTO) {
        UserAccountEntity userAccountInfo = this.userAccountService.getUserAccountInfo(userMedalCounterDTO.getUserId());
        Integer allEggNum = userAccountInfo.getAllEgg();
        this.handleEggMedal(userMedalCounterDTO.getUserId(), allEggNum, UserMedalTypeEnum.EGG_NEW_USER);
        this.handleEggMedal(userMedalCounterDTO.getUserId(), allEggNum, UserMedalTypeEnum.EGG_TALENT);
        this.handleEggMedal(userMedalCounterDTO.getUserId(), allEggNum, UserMedalTypeEnum.EGG_FARMER);
        this.handleEggMedal(userMedalCounterDTO.getUserId(), allEggNum, UserMedalTypeEnum.RICH_ONE_PLACE);
        this.handleEggMedal(userMedalCounterDTO.getUserId(), allEggNum, UserMedalTypeEnum.RICH_EQUAL_STATE);
    }

    @Override
    protected String counterType() {
        return UserMedalCounterTypeEnum.EGG_NUM.name();
    }

    private void handleEggMedal(Long userId, Integer allEggNum, UserMedalTypeEnum userMedalTypeEnum) {
        List<UserMedalInfoEntity> medalInfoEntityList = this.achievementMedalCacheManager.getMedalListByType(userMedalTypeEnum.name());
        for (UserMedalInfoEntity userMedalInfoEntity : medalInfoEntityList) {
            MedalExtDataDTO medalExtDataDTO = (MedalExtDataDTO)JSON.parseObject((String)userMedalInfoEntity.getRuleExtData(), MedalExtDataDTO.class);
            if (allEggNum >= medalExtDataDTO.getTargetValue()) {
                this.grantAchievementMedal(userId, userMedalInfoEntity);
                continue;
            }
            return;
        }
    }

    public EggCounterStrategy(UserAccountService userAccountService) {
        this.userAccountService = userAccountService;
    }
}

