/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.role.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.egg.user.constant.UserEggRoleEnum;
import com.bxm.egg.user.mapper.UserEggRoleMapper;
import com.bxm.egg.user.model.entity.UserEggRoleEntity;
import com.bxm.egg.user.role.UserEggRoleService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserEggRoleServiceImpl
implements UserEggRoleService {
    private static final Logger log = LoggerFactory.getLogger(UserEggRoleServiceImpl.class);
    private final UserEggRoleMapper userEggRoleMapper;

    @Override
    public List<Integer> getUserRoleType(Long userId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserEggRoleEntity::getUserId, (Object)userId);
        List roleEntityList = this.userEggRoleMapper.selectList((Wrapper)queryWrapper);
        List<Integer> roleList = roleEntityList.stream().map(UserEggRoleEntity::getRoleId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(roleList)) {
            roleList = new ArrayList<Integer>();
            roleList.add(UserEggRoleEnum.GENERATE.getCode());
            return roleList;
        }
        return roleList;
    }

    public UserEggRoleServiceImpl(UserEggRoleMapper userEggRoleMapper) {
        this.userEggRoleMapper = userEggRoleMapper;
    }
}

