/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.search.impl;

import com.bxm.egg.user.mapper.UserFollowMapper;
import com.bxm.egg.user.model.param.FollowListParam;
import com.bxm.egg.user.model.vo.FollowUserListVO;
import com.bxm.egg.user.model.vo.UserFollow;
import com.bxm.egg.user.search.UserSearchService;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserSearchServiceImpl
implements UserSearchService {
    private static final Logger log = LoggerFactory.getLogger(UserSearchServiceImpl.class);
    private final UserFollowMapper userFollowMapper;

    @Override
    public List<FollowUserListVO> followList(FollowListParam param) {
        List userFollows = this.userFollowMapper.searchFollow(param);
        return userFollows.stream().map(this::convert).collect(Collectors.toList());
    }

    private FollowUserListVO convert(UserFollow follow) {
        FollowUserListVO listVO = new FollowUserListVO();
        listVO.setUserId(follow.getUserId());
        listVO.setNickname(follow.getNickname());
        listVO.setHeadImg(follow.getHeadImg());
        return listVO;
    }

    public UserSearchServiceImpl(UserFollowMapper userFollowMapper) {
        this.userFollowMapper = userFollowMapper;
    }
}

