/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.timer;

import com.bxm.component.elasticjob.job.ISimplifyElasticJob;
import com.bxm.egg.mq.common.param.DingtalkMessage;
import com.bxm.egg.user.dto.LocationDTO;
import com.bxm.egg.user.info.UserRegCounterService;
import com.bxm.egg.user.integration.LocationIntegrationService;
import com.bxm.egg.user.integration.MessageFacadeIntegrationService;
import com.bxm.egg.user.model.vo.UserStatisticsBean;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.Interval;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.tools.inner.IntervalMap;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RegStatisticsTask
implements ISimplifyElasticJob {
    private static final Logger log = LoggerFactory.getLogger(RegStatisticsTask.class);
    @Resource
    private UserRegCounterService userRegCounterService;
    @Resource
    private MessageFacadeIntegrationService messageFacadeIntegrationService;
    @Resource
    private LocationIntegrationService locationIntegrationService;

    public void execute(ShardingContext shardingContext) {
        IntervalMap intervalMap = DateUtils.getInterval((Interval)Interval.YESTERDAY);
        List<UserStatisticsBean> regUserList = this.userRegCounterService.regUserCounter(intervalMap.getStartTime(), intervalMap.getEndTime());
        List<UserStatisticsBean> migrationList = this.userRegCounterService.migrationUserCounter(intervalMap.getStartTime(), intervalMap.getEndTime());
        for (UserStatisticsBean userStatisticsBean : regUserList) {
            this.handleStatisticsData(userStatisticsBean);
        }
        for (UserStatisticsBean userStatisticsBean : migrationList) {
            this.handleStatisticsData(userStatisticsBean);
        }
        String statisticsDate = DateUtils.formatDate((Date)intervalMap.getStartTime());
        StringBuilder content = new StringBuilder();
        content.append(statisticsDate).append(" \u5404\u4e2a\u533a\u57df\u65b0\u6ce8\u518c\u7528\u6237\uff1a\n");
        int sum = 0;
        for (UserStatisticsBean areaGroup : regUserList) {
            sum += areaGroup.getTotal().intValue();
            content.append(areaGroup.getLocationName()).append(" : ").append(areaGroup.getTotal()).append("\n");
        }
        content.append("\u5171\uff1a[ ").append(sum).append(" ]\u4eba\n");
        DingtalkMessage message = new DingtalkMessage();
        message.setScene("reg");
        message.setContent(content.toString());
        this.messageFacadeIntegrationService.sendDingtalk(message);
        content = new StringBuilder();
        content.append(statisticsDate).append(" \u86cb\u86cb\u4f73\u8fc1\u79fb\u7528\u6237\u6570\u636e\uff1a\n");
        sum = 0;
        for (UserStatisticsBean areaGroup : migrationList) {
            sum += areaGroup.getTotal().intValue();
            content.append(areaGroup.getLocationName()).append(" : ").append(areaGroup.getTotal()).append("\n");
        }
        content.append("\u5171\uff1a[ ").append(sum).append(" ]\u4eba\n");
        message = new DingtalkMessage();
        message.setScene("reg");
        message.setContent(content.toString());
        this.messageFacadeIntegrationService.sendDingtalk(message);
    }

    private void handleStatisticsData(UserStatisticsBean userStatisticsBean) {
        if (StringUtils.isNotBlank((CharSequence)userStatisticsBean.getLocationCode())) {
            LocationDTO locationByGeocode = this.locationIntegrationService.getLocationByGeocode(userStatisticsBean.getLocationCode());
            userStatisticsBean.setLocationName(locationByGeocode.getCode());
        } else {
            userStatisticsBean.setLocationName("\u672a\u77e5\u533a\u57df");
            userStatisticsBean.setLocationCode("-1");
        }
    }

    public String cron() {
        return "0 0/1 * * * ?";
    }

    public String description() {
        return "\u6bcf\u65e5\u65e9\u4e0a9\u70b9\u7edf\u8ba1\u6ce8\u518c\u4eba\u6570\u548c\u8fc1\u79fb\u4eba\u6570";
    }
}

