/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.utils;

import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Lists;
import java.util.List;

public class MaxLengthStringBuilder {
    private int maxLength;
    private List<String> appendStringList;
    private List<Integer> dynamicIndexList;
    private int immutableSize;
    private int index;
    private String placeHolder;

    private MaxLengthStringBuilder(int max) {
        this.maxLength = max;
        this.index = 0;
        this.appendStringList = Lists.newArrayList();
        this.dynamicIndexList = Lists.newArrayList();
        this.placeHolder = "..";
    }

    public static MaxLengthStringBuilder builder(int max) {
        return new MaxLengthStringBuilder(max);
    }

    public MaxLengthStringBuilder appendDynamic(String str) {
        this.appendStringList.add(str);
        this.dynamicIndexList.add(this.index);
        ++this.index;
        return this;
    }

    public MaxLengthStringBuilder appendImmutable(String str) {
        this.appendStringList.add(str);
        this.immutableSize += str.length();
        ++this.index;
        return this;
    }

    public MaxLengthStringBuilder placeHolder(String placeHolder) {
        this.placeHolder = placeHolder;
        return this;
    }

    public String build() {
        int residueSize = this.maxLength - this.immutableSize;
        StringBuilder builder = new StringBuilder();
        int appendIndex = 0;
        for (String appendStr : this.appendStringList) {
            if (this.dynamicIndexList.contains(appendIndex)) {
                if (residueSize <= 0) {
                    builder.append(this.placeHolder);
                } else if ((residueSize -= appendStr.length()) < 0) {
                    builder.append(StringUtils.substring((String)appendStr, (int)0, (int)(appendStr.length() + residueSize)));
                    builder.append(this.placeHolder);
                } else {
                    builder.append(appendStr);
                }
            } else {
                builder.append(appendStr);
            }
            ++appendIndex;
        }
        return builder.toString();
    }

    public String toString() {
        return this.build();
    }
}

