/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.warmlevel.impl.handler;

import com.bxm.egg.user.mapper.warmlevel.UserWarmValueFlowMapper;
import com.bxm.egg.user.model.vo.warmlevel.UserWarmValueFlow;
import com.bxm.egg.user.model.vo.warmlevel.WarmRuleDetail;
import com.bxm.egg.user.warmlevel.UserWarmLevelService;
import com.bxm.egg.user.warmlevel.impl.context.WarmActionContext;
import com.bxm.egg.user.warmlevel.impl.handler.WarmActionHandler;
import com.bxm.egg.user.warmlevel.impl.rule.WarmRule;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractWarmActionHandler
implements WarmActionHandler {
    @Autowired
    private UserWarmValueFlowMapper userWarmValueFlowMapper;
    @Autowired
    private SequenceCreater sequenceCreate;
    protected UserWarmLevelService userWarmLevelService;
    private Map<Class<? extends WarmRule>, WarmRule> ruleMap;

    @Autowired
    public void setRules(List<WarmRule> rules) {
        if (CollectionUtils.isNotEmpty(rules)) {
            this.ruleMap = Maps.newHashMap();
            rules.forEach(rule -> this.ruleMap.put((Class<? extends WarmRule>)rule.getClass(), (WarmRule)rule));
        }
    }

    @Override
    public final Message handle(WarmActionContext context) {
        Message message;
        if (null == this.userWarmLevelService) {
            this.userWarmLevelService = (UserWarmLevelService)SpringContextHolder.getBean(UserWarmLevelService.class);
        }
        if (!(message = this.preAction(context)).isSuccess()) {
            return message;
        }
        this.postAction(context);
        return Message.build((boolean)true);
    }

    private Message preAction(WarmActionContext context) {
        WarmRule rule;
        Message message;
        Class<? extends WarmRule> bindRules = this.bindRules();
        if (bindRules != null && !(message = (rule = this.ruleMap.get(bindRules)).apply(context)).isSuccess()) {
            return message;
        }
        context.getCallback().preAction(context);
        return Message.build((boolean)true);
    }

    private void postAction(WarmActionContext context) {
        this.execAction(context);
        this.saveFlow(context);
        this.syncUserWarm(context);
        context.getCallback().postAction(context);
        this.afterPost(context);
        this.delWarmCacheWarmLevelUp(context);
    }

    protected abstract void afterPost(WarmActionContext var1);

    protected abstract void execAction(WarmActionContext var1);

    private void syncUserWarm(WarmActionContext context) {
        this.userWarmLevelService.updateUserWarmInfo(context.getUserId(), context.getWarmRuleDetail().getWarmValue());
    }

    private void saveFlow(WarmActionContext context) {
        UserWarmValueFlow userWarmValueFlow = new UserWarmValueFlow();
        userWarmValueFlow.setId(this.sequenceCreate.nextLongId());
        userWarmValueFlow.setCreateTime(new Date());
        userWarmValueFlow.setRemark(context.getOriginParam().getRemake());
        userWarmValueFlow.setType(context.getWarmRuleDetail().getType());
        userWarmValueFlow.setTypeDesc(context.getWarmRuleDetail().getTypeDesc());
        userWarmValueFlow.setUserId(context.getUserId());
        userWarmValueFlow.setWarmValue(context.getWarmRuleDetail().getWarmValue());
        this.userWarmValueFlowMapper.insertSelective(userWarmValueFlow);
    }

    WarmRuleDetail getWarmRule(String type) {
        return this.userWarmLevelService.getWarmRule(type);
    }

    private void delWarmCacheWarmLevelUp(WarmActionContext context) {
        this.userWarmLevelService.delWarmCacheWarmLevelUp(context);
    }
}

