/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.warmlevel.impl.handler;

import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.enums.WarmRuleEnum;
import com.bxm.egg.user.warmlevel.impl.context.WarmActionContext;
import com.bxm.egg.user.warmlevel.impl.handler.AbstractWarmActionHandler;
import com.bxm.egg.user.warmlevel.impl.rule.PostAuditSuccessRule;
import com.bxm.egg.user.warmlevel.impl.rule.WarmRule;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserPostAuditActionHandler
extends AbstractWarmActionHandler {
    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Override
    protected void execAction(WarmActionContext context) {
        context.setWarmRuleDetail(this.getWarmRule(context.getAction().name()));
    }

    @Override
    protected void afterPost(WarmActionContext context) {
        KeyGenerator keyGenerator = RedisConfig.USER_AUDIT_POST_WARM.copy().appendKey((Object)DateUtils.formatDate((Date)new Date())).appendKey((Object)context.getUserId());
        this.redisStringAdapter.increment(keyGenerator, 1);
        this.redisStringAdapter.expire(keyGenerator, 172800L);
    }

    @Override
    public WarmRuleEnum support() {
        return WarmRuleEnum.POST_AUDIT_PASS;
    }

    @Override
    public Class<? extends WarmRule> bindRules() {
        return PostAuditSuccessRule.class;
    }
}

