/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.attribute.impl;

import com.bxm.egg.user.attribute.UserFunsService;
import com.bxm.egg.user.enums.UserFollowStatusEnum;
import com.bxm.egg.user.mapper.UserFunsMapper;
import com.bxm.egg.user.model.vo.UserFunsRecord;
import com.bxm.newidea.component.uuid.SequenceCreater;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserFunsServiceImpl
implements UserFunsService {
    private final UserFunsMapper userFunsMapper;
    private final SequenceCreater sequenceCreater;

    @Autowired
    public UserFunsServiceImpl(UserFunsMapper userFunsMapper, SequenceCreater sequenceCreater) {
        this.userFunsMapper = userFunsMapper;
        this.sequenceCreater = sequenceCreater;
    }

    @Override
    public void addFuns(Long userId, Long funsId, byte type) {
        UserFunsRecord funs = new UserFunsRecord();
        funs.setUserId(userId);
        funs.setFunsUserId(funsId);
        funs.setType(Byte.valueOf(type));
        int update = this.userFunsMapper.update(funs);
        if (0 == update) {
            funs.setId(this.sequenceCreater.nextLongId());
            this.userFunsMapper.insert(funs);
        }
    }

    @Override
    public void removeFuns(Long userId, Long funsId) {
        UserFunsRecord funs = new UserFunsRecord();
        funs.setUserId(userId);
        funs.setFunsUserId(funsId);
        funs.setType(Byte.valueOf(UserFollowStatusEnum.UNFOLLOW.getCode()));
        this.userFunsMapper.update(funs);
    }

    @Override
    public void setFuns(Long userId, Long funsId, byte type) {
        UserFunsRecord funs = new UserFunsRecord();
        funs.setUserId(userId);
        funs.setFunsUserId(funsId);
        funs.setType(Byte.valueOf(type));
        this.userFunsMapper.update(funs);
    }
}

