/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.facade;

import com.bxm.egg.user.account.UserAccountService;
import com.bxm.egg.user.facade.enums.OperateTypeEnum;
import com.bxm.egg.user.facade.param.UserEggOperateEggParam;
import com.bxm.egg.user.facade.param.UserEggOperateFoodsParam;
import com.bxm.egg.user.facade.service.UserEggAccountFacadeService;
import com.bxm.egg.user.integration.sync.SixEnjoyUserAccountIntegrationService;
import com.bxm.egg.user.model.entity.UserAccountEntity;
import com.bxm.newidea.component.bo.Message;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DubboService(protocol={"dubbo"}, version="1.0.0")
public class UserEggAccountFacadeServiceImpl
implements UserEggAccountFacadeService {
    private static final Logger log = LoggerFactory.getLogger(UserEggAccountFacadeServiceImpl.class);
    @Resource
    private UserAccountService userAccountService;
    @Resource
    private SixEnjoyUserAccountIntegrationService sixEnjoyUserAccountIntegrationService;

    public Message operateFoods(UserEggOperateFoodsParam param) {
        if (OperateTypeEnum.INCREASE.equals((Object)param.getOperateTypeEnum())) {
            Boolean result = this.sixEnjoyUserAccountIntegrationService.addFoodsNum(param.getUserId(), param.getGoodsNum(), param.getRemark());
            return Message.build((boolean)result);
        }
        if (OperateTypeEnum.REDUCE.equals((Object)param.getOperateTypeEnum())) {
            UserAccountEntity userAccountInfo = this.userAccountService.getUserAccountInfo(param.getUserId());
            if (userAccountInfo == null) {
                return Message.build((boolean)false, (String)"\u7528\u6237\u8d26\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            if (userAccountInfo.getUsableFoods() < param.getGoodsNum()) {
                return Message.build((boolean)false, (String)"\u7528\u6237\u7cae\u98df\u4e0d\u8db3");
            }
            Boolean result = this.sixEnjoyUserAccountIntegrationService.subFoodsNum(param.getUserId(), param.getGoodsNum(), param.getRemark());
            return Message.build((boolean)result);
        }
        return Message.build((boolean)false, (String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5b58\u5728");
    }

    public Message operateEgg(UserEggOperateEggParam param) {
        if (OperateTypeEnum.INCREASE.equals((Object)param.getOperateTypeEnum())) {
            Boolean result = this.sixEnjoyUserAccountIntegrationService.addEggsNum(param.getUserId(), param.getEggNum(), param.getRemark());
            return Message.build((boolean)result);
        }
        if (OperateTypeEnum.REDUCE.equals((Object)param.getOperateTypeEnum())) {
            UserAccountEntity userAccountInfo = this.userAccountService.getUserAccountInfo(param.getUserId());
            if (userAccountInfo == null) {
                return Message.build((boolean)false, (String)"\u7528\u6237\u8d26\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            if (userAccountInfo.getUsableEgg() < param.getEggNum()) {
                return Message.build((boolean)false, (String)"\u7528\u6237\u9e21\u86cb\u4e0d\u8db3");
            }
            Boolean result = this.sixEnjoyUserAccountIntegrationService.subEggsNum(param.getUserId(), param.getEggNum(), param.getRemark());
            return Message.build((boolean)result);
        }
        return Message.build((boolean)false, (String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5b58\u5728");
    }
}

