/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.follow.impl;

import com.bxm.component.mybatis.dto.PlusPageModelDTO;
import com.bxm.egg.user.attribute.UserTagService;
import com.bxm.egg.user.constant.MemoryCacheKeyConfig;
import com.bxm.egg.user.equitylevelmedal.impl.UserEquityLevelMedalServiceImpl;
import com.bxm.egg.user.follow.UserFollowService;
import com.bxm.egg.user.follow.UserRecommendFollowService;
import com.bxm.egg.user.info.UserInfoCacheService;
import com.bxm.egg.user.integration.NewsIntegrationService;
import com.bxm.egg.user.model.bo.UserCacheInfoBO;
import com.bxm.egg.user.model.dto.ImgDTO;
import com.bxm.egg.user.model.equitylevelmedal.UserEquityLevelMedalInfoDTO;
import com.bxm.egg.user.model.param.RecommendFollowUsersParam;
import com.bxm.egg.user.model.vo.RecommendFollowUsersVo;
import com.bxm.egg.user.model.vo.UserTag;
import com.bxm.egg.user.service.BlockUserService;
import com.bxm.egg.user.support.NativeUserService;
import com.bxm.egg.user.utils.ConstellationUtils;
import com.bxm.localnews.news.facade.dto.RecommendUserDTO;
import com.bxm.localnews.news.facade.param.RecommendQueryParam;
import com.bxm.newidea.component.dto.IPageModel;
import com.bxm.newidea.component.sync.core.SyncCacheAgent;
import com.bxm.newidea.component.sync.core.SyncCacheHolderFactory;
import com.bxm.newidea.component.sync.key.SyncCacheKey;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserRecommendFollowServiceImpl
implements UserRecommendFollowService {
    private static final Logger log = LoggerFactory.getLogger(UserRecommendFollowServiceImpl.class);
    private NewsIntegrationService newsIntegrationService;
    private NativeUserService nativeUserService;
    private UserTagService userTagService;
    private UserEquityLevelMedalServiceImpl userEquityLevelMedalService;
    private UserInfoCacheService userInfoCacheService;
    private UserFollowService userFollowService;
    private BlockUserService blockUserService;

    @Override
    public IPageModel<RecommendFollowUsersVo> getRecommendFollowUsers(RecommendFollowUsersParam param) {
        List<Long> followedUserList = this.userFollowService.followUserIdList(param.getUserId());
        SyncCacheAgent cacheAgent = SyncCacheHolderFactory.build((SyncCacheKey)MemoryCacheKeyConfig.RECOMMEND_USER_CACHE_KEY, this::loadRecommendUserList);
        List recommendList = (List)cacheAgent.get((Object)param.getAreaCode());
        recommendList = recommendList.stream().filter(recommendUser -> !followedUserList.contains(recommendUser.getUserId()) && !recommendUser.getUserId().equals(param.getUserId())).collect(Collectors.toList());
        int start = (param.getPageNum() - 1) * param.getPageSize();
        int end = param.getPageNum() * param.getPageSize();
        if (start > recommendList.size()) {
            return new PageWarper((List)Lists.newArrayList());
        }
        if (end > recommendList.size()) {
            end = recommendList.size();
        }
        List pageResult = recommendList.subList(start, end);
        PlusPageModelDTO pageModelDTO = PlusPageModelDTO.build(null).changeList(pageResult);
        pageModelDTO.setLastPage(false);
        pageModelDTO.setHasNextPage(false);
        return pageModelDTO;
    }

    private List<RecommendFollowUsersVo> loadRecommendUserList(String areaCode) {
        ArrayList result = Lists.newArrayList();
        Map blockUserMap = this.blockUserService.listBlockUser();
        for (int i = 1; i <= 5; ++i) {
            RecommendQueryParam param = new RecommendQueryParam();
            param.setPageNum(Integer.valueOf(i));
            param.setPageSize(Integer.valueOf(500));
            param.setAreaCode(areaCode);
            List recommendUserList = this.newsIntegrationService.recommendUserByPage(param);
            int querySize = recommendUserList.size();
            List<RecommendFollowUsersVo> list = recommendUserList.stream().filter(user -> {
                Integer blockType = (Integer)blockUserMap.get(user.getUserId());
                return !Objects.equals(blockType, 1) && !Objects.equals(blockType, 2);
            }).map(this::convert).collect(Collectors.toList());
            List<Long> userIdList = list.stream().map(RecommendFollowUsersVo::getUserId).collect(Collectors.toList());
            this.fillRecommendUserInfo(list, userIdList);
            result.addAll(list);
            if (querySize < param.getPageSize()) break;
        }
        Collections.shuffle(result);
        return result;
    }

    private RecommendFollowUsersVo convert(RecommendUserDTO user) {
        List<Object> imgDTOList = Lists.newArrayList();
        if (user.getRecommendImgList() != null) {
            imgDTOList = user.getRecommendImgList().stream().map(imgDto -> {
                ImgDTO userImgDto = new ImgDTO();
                BeanUtils.copyProperties((Object)imgDto, (Object)userImgDto);
                return userImgDto;
            }).limit(3L).collect(Collectors.toList());
        }
        RecommendFollowUsersVo followUser = new RecommendFollowUsersVo();
        followUser.setUserId(user.getUserId());
        followUser.setImgInfo((List)imgDTOList);
        return followUser;
    }

    private void fillRecommendUserInfo(List<RecommendFollowUsersVo> list, List<Long> userIdList) {
        if (!CollectionUtils.isEmpty(list)) {
            List<UserCacheInfoBO> userInfoList = this.userInfoCacheService.getBatchUserInfo(userIdList);
            List<UserEquityLevelMedalInfoDTO> equityLevelMedalList = this.userEquityLevelMedalService.getEquityLevelMedalList(userIdList);
            Map<Long, List<UserEquityLevelMedalInfoDTO>> equityMedalMap = equityLevelMedalList.stream().collect(Collectors.groupingBy(UserEquityLevelMedalInfoDTO::getUserId));
            Map<Long, List<UserTag>> userTagMap = this.userTagService.getBatchUserTag(userIdList);
            AtomicReference<HashMap> imgMap = new AtomicReference<HashMap>(Maps.newHashMap());
            AtomicReference<HashMap> noteMap = new AtomicReference<HashMap>(Maps.newHashMap());
            list.forEach(recommendFollowUsersVo -> {
                Optional<UserCacheInfoBO> optional = userInfoList.stream().filter(user -> user.getUserId().equals(recommendFollowUsersVo.getUserId())).findFirst();
                if (optional.isPresent()) {
                    List imgList;
                    UserCacheInfoBO userInfo = optional.get();
                    recommendFollowUsersVo.setNickname(userInfo.getNickname());
                    recommendFollowUsersVo.setHeadImg(Objects.nonNull(userInfo.getHeadImg()) ? userInfo.getHeadImg() : null);
                    recommendFollowUsersVo.setSex(userInfo.getSex());
                    recommendFollowUsersVo.setFollowed(Integer.valueOf(0));
                    this.fill((RecommendFollowUsersVo)recommendFollowUsersVo, userInfo);
                    if (Objects.nonNull(userInfo.getUserInformationBO()) && Objects.nonNull(userInfo.getUserInformationBO().getBirthday())) {
                        LocalDate birthday = userInfo.getUserInformationBO().getBirthday().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        recommendFollowUsersVo.setConstellation(ConstellationUtils.calculateConstellation((LocalDate)birthday));
                        recommendFollowUsersVo.setGeneration(this.nativeUserService.getGeneration(userInfo.getUserInformationBO().getBirthday()));
                    }
                    if (!CollectionUtils.isEmpty((Collection)(imgList = (List)((Map)imgMap.get()).get(recommendFollowUsersVo.getUserId())))) {
                        recommendFollowUsersVo.setImgInfo(imgList.size() > 3 ? imgList.subList(0, 3) : imgList);
                    }
                    List<Object> userLabels = new ArrayList();
                    List userTagList = (List)userTagMap.get(recommendFollowUsersVo.getUserId());
                    if (!CollectionUtils.isEmpty((Collection)userTagList)) {
                        userLabels = userTagList.stream().filter(t -> t.getDeleteFlag() == 0).map(UserTag::getLabel).collect(Collectors.toList());
                    }
                    recommendFollowUsersVo.setUserLabels(userLabels);
                    List levelMedalInfoDTOS = (List)equityMedalMap.get(recommendFollowUsersVo.getUserId());
                    if (!CollectionUtils.isEmpty((Collection)levelMedalInfoDTOS)) {
                        UserEquityLevelMedalInfoDTO userEquityLevelMedalInfoDTO = (UserEquityLevelMedalInfoDTO)levelMedalInfoDTOS.get(0);
                        recommendFollowUsersVo.setUserWarmLevelDTO(userEquityLevelMedalInfoDTO.getUserEquityDTO());
                    }
                }
            });
        }
    }

    private void fill(RecommendFollowUsersVo recommendFollowUsersVo, UserCacheInfoBO userInfo) {
        if (Objects.nonNull(userInfo.getUserInformationBO()) && Objects.nonNull(userInfo.getUserInformationBO().getPersonalProfile())) {
            recommendFollowUsersVo.setDesc(userInfo.getUserInformationBO().getPersonalProfile());
        } else {
            recommendFollowUsersVo.setDesc("TA\u8fd8\u6ca1\u6709\u4ecb\u7ecd\u81ea\u5df1");
        }
    }

    public UserRecommendFollowServiceImpl(NewsIntegrationService newsIntegrationService, NativeUserService nativeUserService, UserTagService userTagService, UserEquityLevelMedalServiceImpl userEquityLevelMedalService, UserInfoCacheService userInfoCacheService, UserFollowService userFollowService, BlockUserService blockUserService) {
        this.newsIntegrationService = newsIntegrationService;
        this.nativeUserService = nativeUserService;
        this.userTagService = userTagService;
        this.userEquityLevelMedalService = userEquityLevelMedalService;
        this.userInfoCacheService = userInfoCacheService;
        this.userFollowService = userFollowService;
        this.blockUserService = blockUserService;
    }
}

