/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.invite.egg.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.component.mybatis.dto.PlusPageModelDTO;
import com.bxm.egg.user.info.UserInfoCacheService;
import com.bxm.egg.user.integration.sync.SixEnjoyInviteFoodsIntegrationService;
import com.bxm.egg.user.invite.egg.UserEggInviteService;
import com.bxm.egg.user.mapper.EggInviteMapper;
import com.bxm.egg.user.model.bo.UserCacheInfoBO;
import com.bxm.egg.user.model.dto.invite.egg.InviteUserListDTO;
import com.bxm.egg.user.model.entity.EggInviteEntity;
import com.bxm.egg.user.model.param.invite.egg.InvitePageParam;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.newidea.component.dto.IPageModel;
import com.bxm.sync.facade.dto.UserTodayContributionDTO;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserEggInviteServiceImpl
implements UserEggInviteService {
    private static final Logger log = LoggerFactory.getLogger(UserEggInviteServiceImpl.class);
    @Resource
    private EggInviteMapper eggInviteMapper;
    @Resource
    private UserProperties userProperties;
    @Resource
    private final SixEnjoyInviteFoodsIntegrationService inviteFoodsIntegrationService;
    @Resource
    private UserInfoCacheService userInfoCacheService;

    @Override
    public IPageModel<InviteUserListDTO> inviteList(InvitePageParam invitePageParam) {
        Page page = new Page((long)invitePageParam.getPageNum().intValue(), (long)invitePageParam.getPageSize().intValue());
        page.setSearchCount(false);
        if (null == invitePageParam.getUserId()) {
            return PlusPageModelDTO.build(null);
        }
        IPage result = this.eggInviteMapper.queryInviteByPage(page, invitePageParam.getUserId());
        List userIdList = result.getRecords().stream().map(InviteUserListDTO::getUserId).collect(Collectors.toList());
        List userFoodsList = this.inviteFoodsIntegrationService.getTodayContribution(userIdList);
        result.getRecords().forEach(inviteUser -> {
            Optional<UserTodayContributionDTO> userFoodValue;
            UserCacheInfoBO cacheInfoBO = this.userInfoCacheService.load(inviteUser.getUserId());
            inviteUser.setHeadImg(cacheInfoBO.getHeadImg());
            inviteUser.setNickName(cacheInfoBO.getNickname());
            if (null == inviteUser.getHasEggNum()) {
                inviteUser.setHasEggNum(Integer.valueOf(0));
            }
            if ((userFoodValue = userFoodsList.stream().filter(userFood -> Objects.equals(inviteUser.getUserId(), userFood.getUserId())).findFirst()).isPresent()) {
                inviteUser.setContributeFoodsNum(userFoodValue.get().getFoodNum());
            } else {
                inviteUser.setContributeFoodsNum(Integer.valueOf(0));
            }
        });
        PlusPageModelDTO pageModelDTO = PlusPageModelDTO.build((IPage)result);
        if (result.getRecords().size() == invitePageParam.getPageSize().intValue()) {
            pageModelDTO.setHasNextPage(true);
            pageModelDTO.setLastPage(false);
        } else {
            pageModelDTO.setHasNextPage(false);
            pageModelDTO.setLastPage(true);
        }
        return pageModelDTO;
    }

    @Override
    public Long getInviteUserId(Long userId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(EggInviteEntity::getBeInviteUserId, (Object)userId);
        EggInviteEntity eggInviteEntity = (EggInviteEntity)this.eggInviteMapper.selectOne((Wrapper)queryWrapper);
        if (eggInviteEntity != null) {
            return eggInviteEntity.getUserId();
        }
        return null;
    }

    @Override
    public int countInviteUser(Long userId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(EggInviteEntity::getUserId, (Object)userId);
        return this.eggInviteMapper.selectCount((Wrapper)queryWrapper);
    }

    @Override
    public List<String> getUserInviteHeadImgList(Long userId) {
        return this.eggInviteMapper.getInviteUserHeadImg(userId, this.userProperties.getInviteHeadImgNum().intValue());
    }

    public UserEggInviteServiceImpl(EggInviteMapper eggInviteMapper, UserProperties userProperties, SixEnjoyInviteFoodsIntegrationService inviteFoodsIntegrationService, UserInfoCacheService userInfoCacheService) {
        this.eggInviteMapper = eggInviteMapper;
        this.userProperties = userProperties;
        this.inviteFoodsIntegrationService = inviteFoodsIntegrationService;
        this.userInfoCacheService = userInfoCacheService;
    }
}

