/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.location.listener;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.user.location.UserLocationService;
import com.bxm.egg.user.location.event.UserLocationReportEvent;
import com.bxm.egg.user.model.entity.UserLocationEntity;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class UserLocationReportListener {
    private static final Logger log = LoggerFactory.getLogger(UserLocationReportListener.class);
    private UserLocationService userLocationService;

    @EventListener
    @Async
    public void userLocationInfoReportEvent(UserLocationReportEvent event) {
        if (log.isDebugEnabled()) {
            log.debug("\u76d1\u542c\u5230\u7528\u6237\u4f4d\u7f6e\u66f4\u6539\u4e0a\u62a5\uff1a{}", (Object)JSON.toJSONString((Object)event));
        }
        if (Objects.nonNull(event.getUserId()) && Objects.nonNull(event.getLat()) && Objects.nonNull(event.getLng())) {
            UserLocationEntity userLocationInfo = this.userLocationService.getUserLocationByUserId(event.getUserId());
            if (userLocationInfo == null) {
                log.error("\u7528\u6237\u5b9a\u4f4d\u4e0a\u62a5\u76d1\u542c\u5668\uff0c\u7528\u6237\u5b9a\u4f4d\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e8b\u4ef6\u5185\u5bb9\uff1a{}", (Object)JSON.toJSONString((Object)event));
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("\u7528\u6237id:{}, \u5e93\u4e2d\u7528\u6237\u7ecf\u5ea6\uff1a{}, \u5e93\u4e2d\u7528\u6237\u7eac\u5ea6\uff1a{}\uff0c\u66f4\u65b0\u540e\u7ecf\u5ea6\uff1a{}, \u66f4\u65b0\u540e\u7eac\u5ea6\uff1a{}", new Object[]{event.getUserId(), userLocationInfo.getLastLng(), userLocationInfo.getLastLat(), event.getLng(), event.getLat()});
            }
            if (!Objects.equals(event.getLat(), userLocationInfo.getLastLat()) || !Objects.equals(event.getLng(), userLocationInfo.getLastLng())) {
                UserLocationEntity updateLocationEntity = new UserLocationEntity();
                updateLocationEntity.setUserId(event.getUserId());
                updateLocationEntity.setLastLat(event.getLat());
                updateLocationEntity.setLastLng(event.getLng());
                this.userLocationService.updateUserLocationInfo(event.getUserId(), updateLocationEntity);
            }
        }
    }

    public UserLocationReportListener(UserLocationService userLocationService) {
        this.userLocationService = userLocationService;
    }
}

