/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.login.strategy.support;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.mq.common.constant.SmsTemplateEnum;
import com.bxm.egg.user.constant.UserLoginTypeEnum;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.integration.SmsIntegrationService;
import com.bxm.egg.user.login.strategy.AbstractUserLoginStrategy;
import com.bxm.egg.user.model.dto.login.LoginResultDTO;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.param.login.UserSettingsPasswordLoginParam;
import com.bxm.newidea.component.bo.Message;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SettingsPasswordLoginStrategy
extends AbstractUserLoginStrategy<UserSettingsPasswordLoginParam> {
    private static final Logger log = LoggerFactory.getLogger(SettingsPasswordLoginStrategy.class);
    @Resource
    private UserInfoService userInfoService;
    @Resource
    private SmsIntegrationService smsIntegrationService;

    @Override
    protected Message beforeLoginAuthentication(UserSettingsPasswordLoginParam loginParam) {
        Optional<Long> userPhoneExist = this.userInfoService.userPhoneExist(loginParam.getPhone());
        if (!userPhoneExist.isPresent()) {
            return Message.build((boolean)false, (String)"\u624b\u673a\u53f7\u7801\u4e0d\u5b58\u5728");
        }
        if (!this.smsIntegrationService.verifyByType(SmsTemplateEnum.RESET_PWD, loginParam.getPhone(), loginParam.getSmsCode()).booleanValue()) {
            return Message.build((boolean)false, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        return Message.build((boolean)true);
    }

    @Override
    protected Long checkExists(UserSettingsPasswordLoginParam loginParam) {
        Optional<Long> userPhoneExist = this.userInfoService.userPhoneExist(loginParam.getPhone());
        if (!userPhoneExist.isPresent()) {
            log.error("\u8bbe\u7f6e\u5bc6\u7801\u767b\u5f55\u7684\u7528\u6237\u4e0d\u5b58\u5728\uff0c \u7528\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)loginParam));
            return null;
        }
        loginParam.setUserId(userPhoneExist.get());
        return userPhoneExist.get();
    }

    @Override
    public UserLoginTypeEnum type() {
        return UserLoginTypeEnum.SETTINGS_PASSWORD_LOGIN;
    }

    @Override
    protected boolean saveIdentity(UserSettingsPasswordLoginParam loginParam, Long userId) {
        return true;
    }

    @Override
    protected void fillUserInfo(UserSettingsPasswordLoginParam loginParam, UserInfoEntity newUser) {
    }

    @Override
    protected void afterLogin(LoginResultDTO resultDTO, UserSettingsPasswordLoginParam loginParam) {
        this.userInfoService.updateUserPassword(loginParam.getUserId(), loginParam.getPassword());
    }

    @Override
    protected Message handleNewUser(UserSettingsPasswordLoginParam loginParam) {
        log.error("\u4fee\u6539\u5bc6\u7801\u7684\u7528\u6237\u540d\u4e0d\u5b58\u5728\uff0c\u8df3\u8fc7\u4e86\u524d\u9762\u7684\u767b\u5f55\u6821\u9a8c\uff0c\u9700\u6392\u67e5\u539f\u56e0\uff0c\u767b\u5f55\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)loginParam));
        return Message.build((boolean)false, (String)"\u7528\u6237\u540d\u4e0d\u5b58\u5728");
    }
}

