/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.medal.cache;

import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.mapper.medal.UserMedalInfoMapper;
import com.bxm.egg.user.model.entity.medal.UserMedalInfoEntity;
import com.bxm.newidea.component.redis.RedisListAdapter;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AchievementMedalCacheManager {
    private static final Logger log = LoggerFactory.getLogger(AchievementMedalCacheManager.class);
    private RedisListAdapter redisListAdapter;
    private UserMedalInfoMapper userMedalInfoMapper;

    public List<UserMedalInfoEntity> getAllAchievementMedalList() {
        List achievementMedalList = this.redisListAdapter.range(RedisConfig.ACHIEVEMNET_MEDAL_DATA.copy(), 0L, -1L, UserMedalInfoEntity.class);
        if (CollectionUtils.isEmpty((Collection)achievementMedalList)) {
            if (log.isDebugEnabled()) {
                log.debug("\u6210\u5c31\u52cb\u7ae0\u7f13\u5b58\u5931\u6548\uff0c\u91cd\u65b0\u83b7\u53d6");
            }
            achievementMedalList = this.userMedalInfoMapper.getAllAchievementMedalInfo();
            this.redisListAdapter.leftPush(RedisConfig.ACHIEVEMNET_MEDAL_DATA.copy(), achievementMedalList);
        }
        return achievementMedalList;
    }

    public Map<Long, UserMedalInfoEntity> getMedalId2InfoMap() {
        List<UserMedalInfoEntity> allAchievementMedalList = this.getAllAchievementMedalList();
        return allAchievementMedalList.stream().filter(userMedalInfoEntity -> Objects.nonNull(userMedalInfoEntity.getParentId())).collect(Collectors.toMap(UserMedalInfoEntity::getId, Function.identity()));
    }

    public Map<Long, List<UserMedalInfoEntity>> getMedalParentId2InfoListMap() {
        HashMap<Long, List<UserMedalInfoEntity>> userMedalMap = new HashMap<Long, List<UserMedalInfoEntity>>();
        List<UserMedalInfoEntity> allAchievementMedalList = this.getAllAchievementMedalList();
        List medalParentIdList = allAchievementMedalList.stream().filter(userMedalInfoEntity -> Objects.isNull(userMedalInfoEntity.getParentId())).map(UserMedalInfoEntity::getId).collect(Collectors.toList());
        for (Long medalParentId : medalParentIdList) {
            List medalInfoEntityList = allAchievementMedalList.stream().filter(medalItem -> Objects.nonNull(medalItem.getParentId()) && medalItem.getParentId().equals(medalParentId)).collect(Collectors.toList());
            userMedalMap.put(medalParentId, medalInfoEntityList);
        }
        return userMedalMap;
    }

    public List<Long> getAllMedalParentIdList() {
        List<UserMedalInfoEntity> allAchievementMedalList = this.getAllAchievementMedalList();
        return allAchievementMedalList.stream().filter(userMedalInfoEntity -> Objects.isNull(userMedalInfoEntity.getParentId())).map(UserMedalInfoEntity::getId).collect(Collectors.toList());
    }

    public boolean isMaxLevel(Long parentMedalId, Integer currentLevel) {
        Map<Long, List<UserMedalInfoEntity>> medalParentId2InfoListMap = this.getMedalParentId2InfoListMap();
        List<UserMedalInfoEntity> userMedalInfoEntities = medalParentId2InfoListMap.get(parentMedalId);
        for (UserMedalInfoEntity userMedalInfoEntity : userMedalInfoEntities) {
            if (userMedalInfoEntity.getLevel() <= currentLevel) continue;
            return false;
        }
        return true;
    }

    public List<UserMedalInfoEntity> getMedalListByType(String medalType) {
        List<UserMedalInfoEntity> allAchievementMedalList = this.getAllAchievementMedalList();
        Map<String, List<UserMedalInfoEntity>> resultMap = allAchievementMedalList.stream().filter(achievementMedal -> Objects.nonNull(achievementMedal.getParentId())).collect(Collectors.groupingBy(UserMedalInfoEntity::getType));
        resultMap.forEach((type, entityList) -> entityList.sort(Comparator.comparing(UserMedalInfoEntity::getLevel)));
        return resultMap.get(medalType);
    }

    public AchievementMedalCacheManager(RedisListAdapter redisListAdapter, UserMedalInfoMapper userMedalInfoMapper) {
        this.redisListAdapter = redisListAdapter;
        this.userMedalInfoMapper = userMedalInfoMapper;
    }
}

