/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.medal.strategy;

import com.bxm.egg.user.enums.MedalCategoryEnum;
import com.bxm.egg.user.facade.dto.UserGrantMedalDTO;
import com.bxm.egg.user.integration.DomainIntegrationService;
import com.bxm.egg.user.mapper.medal.UserMedalRelationInfoMapper;
import com.bxm.egg.user.medal.cache.AchievementMedalCacheManager;
import com.bxm.egg.user.medal.cache.UserMedalPopCacheManager;
import com.bxm.egg.user.model.dto.medal.UserMedalCounterDTO;
import com.bxm.egg.user.model.entity.medal.UserMedalInfoEntity;
import com.bxm.egg.user.model.entity.medal.UserMedalRelationInfoEntity;
import com.bxm.egg.user.properties.ClientRouteProperties;
import com.bxm.egg.user.properties.H5JumpAddressProperties;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriUtils;

@Component
public abstract class AbstractMedalCounterStrategy {
    private static final Logger log = LoggerFactory.getLogger(AbstractMedalCounterStrategy.class);
    @Autowired
    private UserMedalRelationInfoMapper userMedalRelationInfoMapper;
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private UserMedalPopCacheManager userMedalPopCacheManager;
    @Autowired
    private H5JumpAddressProperties h5JumpAddressProperties;
    @Autowired
    private DomainIntegrationService domainIntegrationService;
    @Autowired
    private ClientRouteProperties clientRouteProperties;
    @Autowired
    protected AchievementMedalCacheManager achievementMedalCacheManager;

    public void handleData(UserMedalCounterDTO userMedalCounterDTO) {
        this.handleCounterData(userMedalCounterDTO);
    }

    protected abstract void handleCounterData(UserMedalCounterDTO var1);

    protected abstract String counterType();

    protected void grantAchievementMedal(Long userId, UserMedalInfoEntity userMedalInfoEntity) {
        UserMedalRelationInfoEntity userMedalRecord = this.userMedalRelationInfoMapper.getByUserIdAndMedalId(userId, userMedalInfoEntity.getId());
        if (Objects.isNull(userMedalRecord)) {
            UserMedalRelationInfoEntity newGrantInfo = new UserMedalRelationInfoEntity();
            UserMedalRelationInfoEntity userMedalRelationInfoEntity = this.hasWearParentMedal(userId, userMedalInfoEntity);
            newGrantInfo.setId(this.sequenceCreater.nextLongId());
            newGrantInfo.setCreateTime(new Date());
            newGrantInfo.setModifyTime(new Date());
            newGrantInfo.setMedalCategory(MedalCategoryEnum.ACHIEVEMENT_MEDAL.getCode());
            newGrantInfo.setMedalLevel(userMedalInfoEntity.getLevel());
            newGrantInfo.setMedalParentId(userMedalInfoEntity.getParentId());
            newGrantInfo.setMedalId(userMedalInfoEntity.getId());
            newGrantInfo.setUserId(userId);
            if (Objects.isNull(userMedalRelationInfoEntity)) {
                newGrantInfo.setHasWear(Integer.valueOf(0));
                newGrantInfo.setWearOrder(Integer.valueOf(0));
            } else {
                newGrantInfo.setHasWear(Integer.valueOf(1));
                newGrantInfo.setWearOrder(userMedalRelationInfoEntity.getWearOrder());
            }
            this.userMedalRelationInfoMapper.insertSelective(newGrantInfo);
            this.userMedalPopCacheManager.addUserMedalPopCache(userId, this.buildPopCacheData(userId, userMedalInfoEntity));
            if (log.isDebugEnabled()) {
                log.debug("\u4e3a\u7528\u6237\u53d1\u653e\u6210\u5c31\u52cb\u7ae0\uff0c\u7528\u6237id\uff1a{}, \u6210\u5c31\u52cb\u7ae0id\uff1a{}", (Object)userId, (Object)userMedalInfoEntity.getId());
            }
        }
    }

    private UserMedalRelationInfoEntity hasWearParentMedal(Long userId, UserMedalInfoEntity userMedalInfoEntity) {
        List userMedalList = this.userMedalRelationInfoMapper.getUserMedalListByUserAndParentId(userId, userMedalInfoEntity.getParentId());
        if (CollectionUtils.isEmpty((Collection)userMedalList)) {
            return null;
        }
        for (UserMedalRelationInfoEntity userMedalRelationInfoEntity : userMedalList) {
            if (userMedalRelationInfoEntity.getHasWear() != 1) continue;
            UserMedalRelationInfoEntity minLevelMedalRelationInfo = new UserMedalRelationInfoEntity();
            minLevelMedalRelationInfo.setId(userMedalRelationInfoEntity.getId());
            minLevelMedalRelationInfo.setModifyTime(new Date());
            minLevelMedalRelationInfo.setWearOrder(Integer.valueOf(0));
            minLevelMedalRelationInfo.setHasWear(Integer.valueOf(0));
            this.userMedalRelationInfoMapper.updateByPrimaryKeySelective(minLevelMedalRelationInfo);
            return userMedalRelationInfoEntity;
        }
        return null;
    }

    private UserGrantMedalDTO buildPopCacheData(Long userId, UserMedalInfoEntity userMedalInfoEntity) {
        UserGrantMedalDTO userGrantMedalDTO = new UserGrantMedalDTO();
        userGrantMedalDTO.setMedalId(userMedalInfoEntity.getId());
        userGrantMedalDTO.setGrantDate(new Date());
        userGrantMedalDTO.setMedalImgUrl(userMedalInfoEntity.getGifImgUrl());
        userGrantMedalDTO.setMedalName(userMedalInfoEntity.getName());
        userGrantMedalDTO.setJumpUrl(this.buildMyMedalPageUrl(userId));
        return userGrantMedalDTO;
    }

    private String buildMyMedalPageUrl(Long userId) {
        String url = this.domainIntegrationService.getInnerH5BaseUrl() + String.format(this.h5JumpAddressProperties.getMyMedalUrl(), userId);
        url = UriUtils.encode((String)url, (Charset)Charset.defaultCharset());
        return String.format(this.clientRouteProperties.getWebView(), url, UriUtils.encode((String)"\u6211\u7684\u52cb\u7ae0", (Charset)Charset.defaultCharset()));
    }
}

