/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.timer;

import com.bxm.component.elasticjob.job.ISimplifyElasticJob;
import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.medal.UserMedalCounterService;
import com.bxm.egg.user.model.dto.medal.UserMedalCounterDTO;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import java.util.List;
import javax.annotation.Resource;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class MedalHandleTask
implements ISimplifyElasticJob {
    private static final Logger log = LoggerFactory.getLogger(MedalHandleTask.class);
    @Resource
    private UserMedalCounterService userMedalCounterService;
    @Resource
    private RedisSetAdapter redisSetAdapter;
    @Resource
    private UserProperties userProperties;
    @Resource
    @Qualifier(value="globalAsyncTaskExecutor")
    private AsyncTaskExecutor taskExecutor;
    private static final int PARALLEL_THREAD_NUM = 5;

    public void execute(ShardingContext shardingContext) {
        if (log.isDebugEnabled()) {
            log.debug("\u5904\u7406\u52cb\u7ae0\u6570\u636e\u6d88\u606f\u5b9a\u65f6\u4efb\u52a1==========");
        }
        for (int i = 0; i < 5; ++i) {
            this.taskExecutor.execute(() -> {
                List userMedalMsgList;
                do {
                    userMedalMsgList = this.redisSetAdapter.pop(RedisConfig.MEDAL_REFRESH_MSG_LIST, this.userProperties.getHandleMedalMsgSpeech(), UserMedalCounterDTO.class);
                    log.info("\u83b7\u53d6\u5230\u52cb\u7ae0\u6570\u636e\uff1a{}", (Object)userMedalMsgList.size());
                    for (UserMedalCounterDTO userMedalCounterDTO : userMedalMsgList) {
                        this.userMedalCounterService.handleMedalCounterData(userMedalCounterDTO);
                    }
                } while ((long)userMedalMsgList.size() >= this.userProperties.getHandleMedalMsgSpeech());
            });
        }
    }

    public String cron() {
        return "0 0/2 * * * ?";
    }

    public String description() {
        return "\u5904\u7406\u52cb\u7ae0\u6570\u636e\u6d88\u606f";
    }
}

