/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.warmlevel.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.enums.WarmValueEquityEnum;
import com.bxm.egg.user.facade.dto.UserWarmValueUpDTO;
import com.bxm.egg.user.facade.enums.WarmRuleEnum;
import com.bxm.egg.user.facade.param.UserWarmActionParam;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.info.UserStatisticsService;
import com.bxm.egg.user.info.msg.UserInfoChangeSender;
import com.bxm.egg.user.integration.DomainIntegrationService;
import com.bxm.egg.user.mapper.warmlevel.UserLevelLogMapper;
import com.bxm.egg.user.mapper.warmlevel.UserWarmValueFlowMapper;
import com.bxm.egg.user.mapper.warmlevel.WarmEquityDetailMapper;
import com.bxm.egg.user.mapper.warmlevel.WarmLevelMapper;
import com.bxm.egg.user.mapper.warmlevel.WarmRuleDetailMapper;
import com.bxm.egg.user.model.UserEquityDTO;
import com.bxm.egg.user.model.dto.warmlevel.EquityNotAbleInfo;
import com.bxm.egg.user.model.dto.warmlevel.LevelEquityDTO;
import com.bxm.egg.user.model.dto.warmlevel.UserLevelListDTO;
import com.bxm.egg.user.model.dto.warmlevel.UserWarmLevelInfoDTO;
import com.bxm.egg.user.model.dto.warmlevel.UserWarmValueDetailDTO;
import com.bxm.egg.user.model.dto.warmlevel.UserWarmValueRuleDetailDTO;
import com.bxm.egg.user.model.dto.warmlevel.WarmLevelDTO;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.entity.UserStatisticsEntity;
import com.bxm.egg.user.model.param.warmlevel.UserWarmValueDetailParam;
import com.bxm.egg.user.model.vo.warmlevel.UserLevelLog;
import com.bxm.egg.user.model.vo.warmlevel.UserWarmValueFlow;
import com.bxm.egg.user.model.vo.warmlevel.WarmEquityDetail;
import com.bxm.egg.user.model.vo.warmlevel.WarmLevel;
import com.bxm.egg.user.model.vo.warmlevel.WarmRuleDetail;
import com.bxm.egg.user.properties.H5JumpAddressProperties;
import com.bxm.egg.user.properties.UserWarmLevelProperties;
import com.bxm.egg.user.warmlevel.UserWarmLevelService;
import com.bxm.egg.user.warmlevel.impl.WarmHandlerProxy;
import com.bxm.egg.user.warmlevel.impl.context.WarmActionContext;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserWarmLevelServiceImpl
implements UserWarmLevelService {
    private static final Logger log = LoggerFactory.getLogger(UserWarmLevelServiceImpl.class);
    private final UserWarmLevelProperties userWarmLevelProperties;
    private final H5JumpAddressProperties h5JumpAddressProperties;
    private final WarmLevelMapper warmLevelMapper;
    private final WarmEquityDetailMapper warmEquityDetailMapper;
    private final RedisStringAdapter redisStringAdapter;
    private final RedisSetAdapter redisSetAdapter;
    private final RedisListAdapter redisListAdapter;
    private final WarmHandlerProxy warmHandlerProxy;
    private final WarmRuleDetailMapper warmRuleDetailMapper;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final UserLevelLogMapper userLevelLogMapper;
    private final SequenceCreater sequenceCreate;
    private final UserWarmValueFlowMapper userWarmValueFlowMapper;
    private final DomainIntegrationService domainIntegrationService;
    private final UserInfoService userInfoService;
    private final UserStatisticsService userStatisticsService;
    private final UserInfoChangeSender userInfoChangeSender;

    @Override
    public UserEquityDTO getLevelEquityInfo(Integer warmValue) {
        WarmLevel warmLevel = this.warmLevelMapper.getWarmLevelByWarmValue(warmValue);
        if (Objects.isNull(warmLevel)) {
            return new UserEquityDTO();
        }
        List warmEquityDetails = this.warmEquityDetailMapper.listWarmEquityByLevel(warmLevel.getLevel());
        UserEquityDTO userEquityDTO = new UserEquityDTO();
        userEquityDTO.setShowLevel(Boolean.TRUE);
        userEquityDTO.setLevel(warmLevel.getLevel());
        userEquityDTO.setLevelUrl(warmLevel.getLevelUrl());
        if (warmEquityDetails.isEmpty()) {
            userEquityDTO.setEquityType(new String[0]);
            userEquityDTO.setDazzling(Boolean.FALSE);
        } else {
            String[] equityInfo = new String[warmEquityDetails.size()];
            List<String> collect = warmEquityDetails.stream().map(WarmEquityDetail::getType).collect(Collectors.toList());
            equityInfo = collect.toArray(equityInfo);
            userEquityDTO.setEquityType(equityInfo);
            userEquityDTO.setDazzling(Boolean.valueOf(collect.contains(WarmValueEquityEnum.DAZZLING_ID.name())));
        }
        return userEquityDTO;
    }

    @Override
    public List<UserWarmValueRuleDetailDTO> getWarmValueAddInfo() {
        String addRuleDetail = this.userWarmLevelProperties.getAddRuleDetail();
        if (StringUtils.isNotBlank((CharSequence)addRuleDetail)) {
            try {
                return JSONObject.parseArray((String)addRuleDetail, UserWarmValueRuleDetailDTO.class);
            }
            catch (Exception e) {
                log.error("apollo\u914d\u7f6e\u83b7\u53d6\u6e29\u6696\u503c\u589e\u52a0\u89c4\u5219\u8f6c\u6362\u9519\u8bef addRuleDetail\uff1a{}", (Object)addRuleDetail, (Object)e);
                return Lists.newArrayList();
            }
        }
        return Lists.newArrayList();
    }

    @Override
    public List<UserWarmValueRuleDetailDTO> getWarmValueDeductionInfo() {
        String decRuleDetail = this.userWarmLevelProperties.getDecRuleDetail();
        if (StringUtils.isNotBlank((CharSequence)decRuleDetail)) {
            try {
                return JSONObject.parseArray((String)decRuleDetail, UserWarmValueRuleDetailDTO.class);
            }
            catch (Exception e) {
                log.error("apollo\u914d\u7f6e\u83b7\u53d6\u6e29\u6696\u503c\u6263\u9664\u89c4\u5219\u8f6c\u6362\u9519\u8bef addRuleDetail\uff1a{}", (Object)decRuleDetail, (Object)e);
                return Lists.newArrayList();
            }
        }
        return Lists.newArrayList();
    }

    @Override
    public UserWarmLevelInfoDTO getUserWarmValueInfo(Long userId) {
        Boolean exists = this.redisSetAdapter.exists(RedisConfig.USER_WARM_FIRST_INTO, (Object)userId);
        UserWarmLevelInfoDTO warmLevelInfoDTO = this.getUserWarmInfoCache(userId);
        if (exists.booleanValue()) {
            warmLevelInfoDTO.setShowTips(Boolean.FALSE);
        } else {
            this.redisSetAdapter.add(RedisConfig.USER_WARM_FIRST_INTO, new Object[]{userId});
            warmLevelInfoDTO.setShowTips(Boolean.TRUE);
        }
        return warmLevelInfoDTO;
    }

    @Override
    public UserWarmLevelInfoDTO getUserWarmInfoCache(Long userId) {
        UserWarmLevelInfoDTO warmLevelInfoDTO = (UserWarmLevelInfoDTO)this.redisStringAdapter.get(this.buildUserCacheKey(userId), UserWarmLevelInfoDTO.class);
        if (Objects.isNull(warmLevelInfoDTO)) {
            warmLevelInfoDTO = this.loadUserWarmInfoToRedis(userId);
        }
        return warmLevelInfoDTO;
    }

    private UserWarmLevelInfoDTO loadUserWarmInfoToRedis(Long userId) {
        UserInfoEntity user = this.userInfoService.selectAllUserById(userId);
        if (user == null) {
            return new UserWarmLevelInfoDTO();
        }
        UserStatisticsEntity userStatisticsEntity = this.userStatisticsService.selectUserStatisticsByUserId(userId);
        if (userStatisticsEntity == null) {
            return this.buildDefaultInvalidWarmLevelInfo(userId, user);
        }
        UserEquityDTO levelEquityInfo = this.getLevelEquityInfo(userStatisticsEntity.getWarmValue());
        UserWarmLevelInfoDTO userWarmLevelInfoDTO = new UserWarmLevelInfoDTO();
        userWarmLevelInfoDTO.setHeadImg(user.getHeadImg());
        userWarmLevelInfoDTO.setLevel(levelEquityInfo.getLevel());
        userWarmLevelInfoDTO.setLevelUrl(levelEquityInfo.getLevelUrl());
        userWarmLevelInfoDTO.setNickname(user.getNickname());
        userWarmLevelInfoDTO.setUserId(userId);
        userWarmLevelInfoDTO.setWarmValue(userStatisticsEntity.getWarmValue());
        userWarmLevelInfoDTO.setEquityDTO(levelEquityInfo);
        this.redisStringAdapter.set(this.buildUserCacheKey(userId), (Object)userWarmLevelInfoDTO, 3600L);
        return userWarmLevelInfoDTO;
    }

    private UserWarmLevelInfoDTO buildDefaultInvalidWarmLevelInfo(Long userId, UserInfoEntity user) {
        UserWarmLevelInfoDTO invalidUserWarmLevelInfoDTO = new UserWarmLevelInfoDTO();
        invalidUserWarmLevelInfoDTO.setNickname(user.getNickname());
        invalidUserWarmLevelInfoDTO.setUserId(userId);
        invalidUserWarmLevelInfoDTO.setWarmValue(Integer.valueOf(0));
        invalidUserWarmLevelInfoDTO.setHeadImg(user.getHeadImg());
        UserEquityDTO levelEquityInfo = this.getLevelEquityInfo(0);
        invalidUserWarmLevelInfoDTO.setLevel(levelEquityInfo.getLevel());
        invalidUserWarmLevelInfoDTO.setLevelUrl(levelEquityInfo.getLevelUrl());
        invalidUserWarmLevelInfoDTO.setShowTips(Boolean.valueOf(false));
        invalidUserWarmLevelInfoDTO.setEquityDTO(this.getLevelEquityInfo(0));
        return invalidUserWarmLevelInfoDTO;
    }

    private KeyGenerator buildUserCacheKey(Long userId) {
        return RedisConfig.USER_WARM_INFO.copy().appendKey((Object)userId);
    }

    @Override
    public List<UserLevelListDTO> getUserLevelList(Long userId) {
        UserWarmLevelInfoDTO userWarmValueInfo = this.getUserWarmValueInfo(userId);
        List<WarmLevelDTO> warmLevels = this.getWarmLevelList();
        List userLevelList = this.userLevelLogMapper.getUserLevelList(userId);
        HashMap levelLogMap = new HashMap();
        userLevelList.forEach(userLevelLog -> levelLogMap.put(userLevelLog.getLevel(), userLevelLog));
        List<LevelEquityDTO> levelEquityList = this.getLevelEquityList();
        List userLevelListDTOS = warmLevels.stream().map(warmLevelDTO -> this.covertUserLevelInfo(userWarmValueInfo.getWarmValue(), (WarmLevelDTO)warmLevelDTO, levelEquityList, levelLogMap)).collect(Collectors.toList());
        return userLevelListDTOS.stream().sorted(Comparator.comparing(UserLevelListDTO::getLevel)).collect(Collectors.toList());
    }

    private UserLevelListDTO covertUserLevelInfo(Integer warmValue, WarmLevelDTO warmLevel, List<LevelEquityDTO> levelEquityList, Map<Integer, UserLevelLog> levelLogMap) {
        UserLevelListDTO userLevelListDTO = new UserLevelListDTO();
        userLevelListDTO.setCurrWarmValue(warmValue);
        userLevelListDTO.setLevel(warmLevel.getLevel());
        int equityNum = (int)levelEquityList.stream().filter(levelEquityDTO -> levelEquityDTO.getMinLevel() <= warmLevel.getLevel()).count();
        if (Objects.isNull(warmLevel.getMax())) {
            if (warmValue >= warmLevel.getMin()) {
                userLevelListDTO.setLevelStatus(Integer.valueOf(0));
                UserLevelLog userLevelLog = levelLogMap.get(warmLevel.getLevel());
                userLevelListDTO.setFinishDate(Objects.isNull(userLevelLog) ? new Date() : userLevelLog.getCreateTime());
                userLevelListDTO.setEquityNum(Integer.valueOf(equityNum));
            } else {
                userLevelListDTO.setLevelStatus(Integer.valueOf(2));
                userLevelListDTO.setEquityNum(Integer.valueOf(equityNum));
                userLevelListDTO.setNextWarmValue(warmLevel.getMin());
                userLevelListDTO.setNextLevel(warmLevel.getLevel());
            }
            return userLevelListDTO;
        }
        if (warmValue >= warmLevel.getMin() && warmValue < warmLevel.getMax()) {
            userLevelListDTO.setLevelStatus(Integer.valueOf(0));
            userLevelListDTO.setEquityNum(Integer.valueOf(equityNum));
            userLevelListDTO.setNextWarmValue(warmLevel.getMax());
            userLevelListDTO.setNextLevel(Integer.valueOf(warmLevel.getLevel() + 1));
        }
        if (warmValue < warmLevel.getMin()) {
            userLevelListDTO.setLevelStatus(Integer.valueOf(2));
            userLevelListDTO.setEquityNum(Integer.valueOf(equityNum));
            userLevelListDTO.setNextWarmValue(warmLevel.getMin());
            userLevelListDTO.setNextLevel(warmLevel.getLevel());
        }
        if (warmValue > warmLevel.getMax()) {
            userLevelListDTO.setLevelStatus(Integer.valueOf(1));
            userLevelListDTO.setEquityNum(Integer.valueOf(equityNum));
            userLevelListDTO.setNextWarmValue(warmLevel.getMin());
            userLevelListDTO.setNextLevel(warmLevel.getLevel());
            UserLevelLog userLevelLog = levelLogMap.get(warmLevel.getLevel());
            userLevelListDTO.setFinishDate(Objects.isNull(userLevelLog) ? new Date() : userLevelLog.getCreateTime());
        }
        return userLevelListDTO;
    }

    private List<WarmLevelDTO> getWarmLevelList() {
        KeyGenerator keyGenerator = RedisConfig.USER_WARM_LEVEL_LIST.copy().appendKey((Object)"list");
        List<WarmLevelDTO> warmLevelDTOList = this.redisListAdapter.leftIndex(keyGenerator, -1L, (TypeReference)new TypeReference<WarmLevelDTO>(){});
        if (CollectionUtils.isEmpty((Collection)warmLevelDTOList)) {
            List warmLevelList = this.warmLevelMapper.getWarmLevelList();
            warmLevelDTOList = warmLevelList.stream().map(warmLevel -> {
                WarmLevelDTO warmLevelDTO = WarmLevelDTO.builder().build();
                warmLevelDTO.setLevel(warmLevel.getLevel());
                warmLevelDTO.setLevelUrl(warmLevel.getLevelUrl());
                warmLevelDTO.setMax(warmLevel.getMaxValue());
                warmLevelDTO.setMin(warmLevel.getMinValue());
                return warmLevelDTO;
            }).collect(Collectors.toList());
            this.redisListAdapter.leftPush(keyGenerator, warmLevelDTOList);
            return warmLevelDTOList;
        }
        return warmLevelDTOList;
    }

    @Override
    public List<LevelEquityDTO> getLevelEquityList() {
        KeyGenerator keyGenerator = RedisConfig.USER_WARM_EQUITY_LIST.copy().appendKey((Object)"list");
        List levelEquityDTOS = this.redisListAdapter.leftIndex(keyGenerator, -1L, (TypeReference)new TypeReference<LevelEquityDTO>(){});
        if (CollectionUtils.isEmpty((Collection)levelEquityDTOS)) {
            List levelEquityList = this.warmEquityDetailMapper.getLevelEquityList();
            levelEquityDTOS = levelEquityList.stream().map(equityDetail -> {
                LevelEquityDTO levelEquityDTO = LevelEquityDTO.builder().build();
                levelEquityDTO.setContent(equityDetail.getContent());
                levelEquityDTO.setLockImg(equityDetail.getLockUrl());
                levelEquityDTO.setMinLevel(equityDetail.getMinLevel());
                levelEquityDTO.setUnlockImg(equityDetail.getUnlockUrl());
                levelEquityDTO.setEquityImg(equityDetail.getEquityUrl());
                levelEquityDTO.setType(equityDetail.getType());
                levelEquityDTO.setTitle(equityDetail.getTitle());
                return levelEquityDTO;
            }).collect(Collectors.toList());
            this.redisListAdapter.leftPush(keyGenerator, levelEquityDTOS);
            return levelEquityDTOS.stream().sorted(Comparator.comparing(LevelEquityDTO::getMinLevel)).collect(Collectors.toList());
        }
        return levelEquityDTOS.stream().sorted(Comparator.comparing(LevelEquityDTO::getMinLevel)).collect(Collectors.toList());
    }

    @Override
    public Boolean mockWarmAddOrDec(Long userId, Integer warmValue, WarmRuleEnum warmRuleEnum) {
        UserWarmActionParam warmActionParam = UserWarmActionParam.builder().build();
        warmActionParam.setWarmRuleEnum(Objects.isNull(warmRuleEnum) ? WarmRuleEnum.DEFAULT : warmRuleEnum);
        warmActionParam.setUserId(userId);
        warmActionParam.setWarmValue(warmValue);
        this.warmHandlerProxy.handle(warmActionParam);
        return true;
    }

    @Override
    public WarmRuleDetail getWarmRule(String type) {
        WarmRuleDetail warmRuleDetail = (WarmRuleDetail)this.redisHashMapAdapter.get(RedisConfig.WARM_RULE_DATA, type, WarmRuleDetail.class);
        if (Objects.isNull(warmRuleDetail)) {
            Map<String, WarmRuleDetail> stringWarmRuleDetailMap = this.loadWarmDataToRedis();
            return stringWarmRuleDetailMap.get(type);
        }
        return warmRuleDetail;
    }

    private Map<String, WarmRuleDetail> loadWarmDataToRedis() {
        List warmRuleList = this.warmRuleDetailMapper.getWarmRuleList();
        HashMap<String, WarmRuleDetail> map = new HashMap<String, WarmRuleDetail>((int)((float)warmRuleList.size() / 0.75f + 1.0f));
        warmRuleList.forEach(warmRuleDetail -> map.put(warmRuleDetail.getType(), (WarmRuleDetail)warmRuleDetail));
        this.redisHashMapAdapter.putAll(RedisConfig.WARM_RULE_DATA, map);
        return map;
    }

    @Override
    public void delWarmCacheWarmLevelUp(WarmActionContext context) {
        Boolean exists;
        boolean popResult;
        this.redisStringAdapter.remove(this.buildUserCacheKey(context.getUserId()));
        Integer userLevelCount = this.userLevelLogMapper.getUserLevelCount(context.getUserId());
        WarmLevel warmLevel = this.warmLevelMapper.getWarmLevelByUserId(context.getUserId());
        if (userLevelCount >= warmLevel.getLevel()) {
            return;
        }
        this.userInfoChangeSender.sendUserChangeMsg(context.getUserId());
        ArrayList<UserLevelLog> userLevelLogs = new ArrayList<UserLevelLog>();
        int logLevel = 1;
        if (userLevelCount > 0) {
            logLevel = userLevelCount + 1;
        }
        for (int i = logLevel; i <= warmLevel.getLevel(); ++i) {
            UserLevelLog userLevelLog = new UserLevelLog();
            userLevelLog.setCreateTime(new Date());
            userLevelLog.setId(this.sequenceCreate.nextLongId());
            userLevelLog.setLevel(Integer.valueOf(i));
            userLevelLog.setUserId(context.getUserId());
            userLevelLogs.add(userLevelLog);
        }
        if (!userLevelLogs.isEmpty()) {
            this.userLevelLogMapper.batchInsertLog(userLevelLogs);
        }
        boolean bl = popResult = (Objects.isNull(exists = this.redisSetAdapter.exists(RedisConfig.USER_WARM_LEVEL_PUSH.copy().appendKey((Object)warmLevel.getLevel()), (Object)context.getUserId())) || exists == false) && warmLevel.getLevel() > userLevelCount;
        if (popResult) {
            this.addUserLevelPop(context.getUserId(), warmLevel.getLevel(), warmLevel.getLevelPopUrl());
            this.redisSetAdapter.add(RedisConfig.USER_WARM_LEVEL_PUSH.copy().appendKey((Object)warmLevel.getLevel()), new Object[]{context.getUserId()});
        }
    }

    private void addUserLevelPop(Long userId, Integer level, String levelUrl) {
        KeyGenerator key = RedisConfig.USER_LEVLE_UP_POP.copy().appendKey((Object)userId);
        this.redisListAdapter.remove(key);
        UserWarmValueUpDTO userWarmValueUpDTO = new UserWarmValueUpDTO();
        userWarmValueUpDTO.setLevel(level);
        userWarmValueUpDTO.setLevelUrl(levelUrl);
        String innerH5BaseUrl = this.domainIntegrationService.getInnerH5BaseUrl();
        userWarmValueUpDTO.setJumpUrl(innerH5BaseUrl + this.h5JumpAddressProperties.getLevelJumpUrl());
        this.redisListAdapter.leftPush(key, new Object[]{userWarmValueUpDTO});
        this.redisListAdapter.expire(key, 1296000L);
    }

    @Override
    public List<UserWarmValueDetailDTO> getWarmDetailListByUser(UserWarmValueDetailParam userWarmValueDetailParam) {
        Page page = new Page((long)userWarmValueDetailParam.getPageNum().intValue(), (long)userWarmValueDetailParam.getPageSize().intValue());
        IPage warmDetailListByUser = this.userWarmValueFlowMapper.getWarmDetailListByUser((IPage)page, userWarmValueDetailParam);
        return warmDetailListByUser.getRecords().stream().map(this::covertWarmDetail).collect(Collectors.toList());
    }

    private UserWarmValueDetailDTO covertWarmDetail(UserWarmValueFlow userWarmValueFlow) {
        UserWarmValueDetailDTO userWarmValueDetailDTO = UserWarmValueDetailDTO.builder().build();
        userWarmValueDetailDTO.setCreateTime(userWarmValueFlow.getCreateTime());
        userWarmValueDetailDTO.setDetailStr(userWarmValueFlow.getTypeDesc());
        userWarmValueDetailDTO.setUserId(userWarmValueFlow.getUserId());
        userWarmValueDetailDTO.setWarmValue(userWarmValueFlow.getWarmValue());
        return userWarmValueDetailDTO;
    }

    @Override
    public UserWarmValueUpDTO getUserLevelPopData(Long userId) {
        return (UserWarmValueUpDTO)this.redisListAdapter.leftPop(RedisConfig.USER_LEVLE_UP_POP.copy().appendKey((Object)userId), UserWarmValueUpDTO.class);
    }

    @Override
    public EquityNotAbleInfo getNotAvailablePopupExplain(Long userId, String type) {
        List<LevelEquityDTO> levelEquityList = this.getLevelEquityList();
        List levelEquityDTOS = levelEquityList.stream().filter(levelEquityDTO -> levelEquityDTO.getType().equals(type)).collect(Collectors.toList());
        if (!levelEquityDTOS.isEmpty()) {
            EquityNotAbleInfo equityNotAbleInfo = new EquityNotAbleInfo();
            equityNotAbleInfo.setLevel(((LevelEquityDTO)levelEquityDTOS.get(0)).getMinLevel());
            equityNotAbleInfo.setEquityDesc(((LevelEquityDTO)levelEquityDTOS.get(0)).getTitle());
            return equityNotAbleInfo;
        }
        return null;
    }

    @Override
    public void updateUserWarmInfo(Long userId, Integer warmValue) {
        List<WarmLevelDTO> warmLevels = this.getWarmLevelList();
        List warmLevel1Info = warmLevels.stream().filter(warmLevelDTO -> warmLevelDTO.getLevel().equals(1)).collect(Collectors.toList());
        this.userStatisticsService.updateUserWarmInfo(userId, warmValue, ((WarmLevelDTO)warmLevel1Info.get(0)).getMin());
    }

    public UserWarmLevelServiceImpl(UserWarmLevelProperties userWarmLevelProperties, H5JumpAddressProperties h5JumpAddressProperties, WarmLevelMapper warmLevelMapper, WarmEquityDetailMapper warmEquityDetailMapper, RedisStringAdapter redisStringAdapter, RedisSetAdapter redisSetAdapter, RedisListAdapter redisListAdapter, WarmHandlerProxy warmHandlerProxy, WarmRuleDetailMapper warmRuleDetailMapper, RedisHashMapAdapter redisHashMapAdapter, UserLevelLogMapper userLevelLogMapper, SequenceCreater sequenceCreate, UserWarmValueFlowMapper userWarmValueFlowMapper, DomainIntegrationService domainIntegrationService, UserInfoService userInfoService, UserStatisticsService userStatisticsService, UserInfoChangeSender userInfoChangeSender) {
        this.userWarmLevelProperties = userWarmLevelProperties;
        this.h5JumpAddressProperties = h5JumpAddressProperties;
        this.warmLevelMapper = warmLevelMapper;
        this.warmEquityDetailMapper = warmEquityDetailMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.redisSetAdapter = redisSetAdapter;
        this.redisListAdapter = redisListAdapter;
        this.warmHandlerProxy = warmHandlerProxy;
        this.warmRuleDetailMapper = warmRuleDetailMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.userLevelLogMapper = userLevelLogMapper;
        this.sequenceCreate = sequenceCreate;
        this.userWarmValueFlowMapper = userWarmValueFlowMapper;
        this.domainIntegrationService = domainIntegrationService;
        this.userInfoService = userInfoService;
        this.userStatisticsService = userStatisticsService;
        this.userInfoChangeSender = userInfoChangeSender;
    }
}

