/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.warmlevel.impl.handler;

import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.facade.enums.WarmRuleEnum;
import com.bxm.egg.user.model.vo.warmlevel.WarmRuleDetail;
import com.bxm.egg.user.warmlevel.impl.context.WarmActionContext;
import com.bxm.egg.user.warmlevel.impl.handler.AbstractWarmActionHandler;
import com.bxm.egg.user.warmlevel.impl.rule.ContinuitySignRule;
import com.bxm.egg.user.warmlevel.impl.rule.WarmRule;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserContinuitySignActionHandler
extends AbstractWarmActionHandler {
    @Autowired
    private RedisSetAdapter redisSetAdapter;

    @Override
    protected void execAction(WarmActionContext context) {
        WarmRuleDetail warmRule = this.getWarmRule(context.getAction().name());
        warmRule.setWarmValue(context.getOriginParam().getWarmValue());
        context.setWarmRuleDetail(warmRule);
    }

    @Override
    protected void afterPost(WarmActionContext context) {
        KeyGenerator key = RedisConfig.USER_SIGN_WARM.copy().appendKey((Object)DateUtils.formatDate((Date)new Date()));
        this.redisSetAdapter.add(key, new Object[]{context.getUserId()});
    }

    @Override
    public WarmRuleEnum support() {
        return WarmRuleEnum.CONTINUITY_SIGN;
    }

    @Override
    public Class<? extends WarmRule> bindRules() {
        return ContinuitySignRule.class;
    }
}

