/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.warmlevel.impl.rule;

import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.facade.enums.WarmRuleEnum;
import com.bxm.egg.user.model.vo.warmlevel.WarmRuleDetail;
import com.bxm.egg.user.warmlevel.UserWarmLevelService;
import com.bxm.egg.user.warmlevel.impl.context.WarmActionContext;
import com.bxm.egg.user.warmlevel.impl.rule.WarmRule;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import java.util.Date;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommentRule
implements WarmRule {
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    protected UserWarmLevelService userWarmLevelService;

    @Override
    public Message apply(WarmActionContext context) {
        if (null == this.userWarmLevelService) {
            this.userWarmLevelService = (UserWarmLevelService)SpringContextHolder.getBean(UserWarmLevelService.class);
        }
        WarmRuleDetail warmRule = this.userWarmLevelService.getWarmRule(WarmRuleEnum.COMMENT.name());
        KeyGenerator keyGenerator = RedisConfig.USER_COMMENT_WARM.copy().appendKey((Object)DateUtils.formatDate((Date)new Date())).appendKey((Object)context.getUserId());
        Integer num = (Integer)this.redisStringAdapter.get(keyGenerator, Integer.class);
        if (Objects.nonNull(num) && warmRule.getMaxGainValue() <= num) {
            return Message.build((boolean)false).setMessage("\u5df2\u53d1\u653e\u8fc7\u5e16\u5b50\u8bc4\u8bba\u6e29\u6696\u503c\u5956\u52b1");
        }
        return Message.build((boolean)true);
    }

    @Override
    public boolean retryOnFailed() {
        return false;
    }
}

