package com.bxm.egg.user.facade;

import com.bxm.egg.user.enums.OperateTypeEnum;
import com.bxm.egg.user.facade.param.UserEggOperateFoodsParam;
import com.bxm.egg.user.facade.service.UserEggAccountFacadeService;
import com.bxm.egg.user.integration.sync.SixEnjoyUserAccountIntegrationService;
import com.bxm.newidea.component.bo.Message;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboService;

import javax.annotation.Resource;

/**
 * 用户账户内部服务实现
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/28 6:13 下午
 */
@DubboService(protocol = {"dubbo"}, version = "1.0.0")
@Slf4j
public class UserEggAccountFacadeServiceImpl implements UserEggAccountFacadeService {

    @Resource
    private SixEnjoyUserAccountIntegrationService sixEnjoyUserAccountIntegrationService;

    @Override
    public Message operateFoods(UserEggOperateFoodsParam param) {

        if (OperateTypeEnum.INCREASE.equals(param.getOperateTypeEnum())) {
            Boolean result = sixEnjoyUserAccountIntegrationService.addFoodsNum(param.getUserId(),
                    param.getGoodsNum(), param.getRemark());
            return Message.build(result);
        } else if (OperateTypeEnum.REDUCE.equals(param.getOperateTypeEnum())) {
            Boolean result = sixEnjoyUserAccountIntegrationService.subFoodsNum(param.getUserId(),
                    param.getGoodsNum(), param.getRemark());
            return Message.build(result);
        }
        return Message.build(false, "操作类型不存在");
    }
}