package com.bxm.egg.user.facade;

import com.bxm.egg.user.dto.UserGrantMedalDTO;
import com.bxm.egg.user.facade.service.UserMedalFacadeService;
import com.bxm.egg.user.medal.UserMedalPopService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboService;

import javax.annotation.Resource;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/15 3:22 下午
 */
@DubboService(protocol = {"dubbo"}, version = "1.0.0")
@Slf4j
public class UserMedalFacadeServiceImpl implements UserMedalFacadeService {

    @Resource
    private UserMedalPopService userMedalPopService;

    @Override
    public UserGrantMedalDTO getUserMedalPop(Long userId) {
        return userMedalPopService.getUserMedalPopData(userId);
    }
}