package com.bxm.egg.user.follow.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.component.mybatis.dto.PlusPageModelDTO;
import com.bxm.egg.user.attribute.UserTagService;
import com.bxm.egg.user.equitylevelmedal.impl.UserEquityLevelMedalServiceImpl;
import com.bxm.egg.user.follow.UserFollowService;
import com.bxm.egg.user.follow.UserRecommendFollowService;
import com.bxm.egg.user.info.UserInfoCacheService;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.integration.NewsIntegrationService;
import com.bxm.egg.user.integration.UserNewsIntegrationService;
import com.bxm.egg.user.model.bo.UserCacheInfoBO;
import com.bxm.egg.user.model.dto.ImgDTO;
import com.bxm.egg.user.model.dto.NoteDTO;
import com.bxm.egg.user.model.equitylevelmedal.UserEquityLevelMedalInfoDTO;
import com.bxm.egg.user.model.param.RecommendFollowUsersParam;
import com.bxm.egg.user.model.vo.RecommendFollowUsersVo;
import com.bxm.egg.user.model.vo.UserTag;
import com.bxm.egg.user.service.BlockUserService;
import com.bxm.egg.user.support.NativeUserService;
import com.bxm.egg.user.utils.ConstellationUtils;
import com.bxm.egg.user.vo.RecommendUserFacadeVo;
import com.bxm.newidea.component.dto.IPageModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * 用户推荐关注service
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/22 4:28 下午
 */
@Slf4j
@Service
public class UserRecommendFollowServiceImpl implements UserRecommendFollowService {
    @Resource
    private NewsIntegrationService newsIntegrationService;

    @Resource
    private NativeUserService nativeUserService;

    @Resource
    private UserNewsIntegrationService userNewsIntegrationService;

    @Resource
    private UserTagService userTagService;

    @Autowired
    private UserEquityLevelMedalServiceImpl userEquityLevelMedalService;

    @Resource
    private UserInfoCacheService userInfoCacheService;

    @Resource
    private UserInfoService userInfoService;

    @Resource
    private UserFollowService userFollowService;

    @Resource
    private BlockUserService blockUserService;

    @Override
    public IPageModel<RecommendFollowUsersVo> getRecommendFollowUsers(RecommendFollowUsersParam param) {
        Page<RecommendFollowUsersVo> forumPostPage = new Page<>();

        //获取已关注用户列表，应该是为了去掉这部分已经关注的用户
        List<Long> followedUserList = userFollowService.followUserIdList(param.getUserId());
        if (!CollectionUtils.isEmpty(followedUserList)) {
            followedUserList.add(param.getUserId());
        } else {
            followedUserList = Lists.newArrayList(param.getUserId());
        }

        //获取可推荐的用户id
        List<RecommendUserFacadeVo> recommendUserIds = newsIntegrationService.getRecommendUserList(param.getAreaCode(),
                //用户信息不为空且不是黑户（管理后台处理的）
                param.getUserId()).stream().filter(item -> userInfoService.selectUserById(item.getUserId()) != null &&
                !blockUserService.isBlockLimitUser(item.getUserId()))
                .collect(Collectors.toList());
        List<Long> userIds = recommendUserIds.stream().map(RecommendUserFacadeVo::getUserId).collect(Collectors.toList());

        int start = (param.getPageNum() - 1) * param.getPageSize();
        int end = param.getPageNum() * param.getPageSize();
        if (start < 0) {
            start = 0;
        }
        if (end > userIds.size()) {
            end = userIds.size();
        }
        //根据分页截取推荐用户id集合
        List<Long> userIdsForCurrentPage = userIds.subList(start, end);

        if (CollectionUtils.isEmpty(userIdsForCurrentPage)) {
            forumPostPage.setRecords(Collections.emptyList());
            return PlusPageModelDTO.build(forumPostPage);
        }

        List<RecommendFollowUsersVo> resultList = new ArrayList<>();
        for (Long userId : userIdsForCurrentPage) {
            RecommendFollowUsersVo recommendFollowUsersVo = new RecommendFollowUsersVo();
            recommendFollowUsersVo.setUserId(userId);
            resultList.add(recommendFollowUsersVo);
        }

        //填充其他属性值
        resultList = fillRecommendUserInfo(resultList, userIdsForCurrentPage, param);

        forumPostPage.setRecords(resultList);

        //这里删除了组装分页参数的代码，因为感觉前端用不上

        return PlusPageModelDTO.build(forumPostPage);
    }

    /**
     * 填充推荐用户信息
     *
     * @param list       推荐用户列表
     * @param userIdList 用户idList
     * @param param      入参
     * @return 推荐用户列表
     */
    private List<RecommendFollowUsersVo> fillRecommendUserInfo(List<RecommendFollowUsersVo> list,
                                                               List<Long> userIdList,
                                                               RecommendFollowUsersParam param) {
        if (!CollectionUtils.isEmpty(list)) {
            List<UserCacheInfoBO> userInfoList = userInfoCacheService.getBatchUserInfo(userIdList);

            //获取用户等级勋章信息
            List<UserEquityLevelMedalInfoDTO> equityLevelMedalList = userEquityLevelMedalService.getEquityLevelMedalList(userIdList);
            Map<Long, List<UserEquityLevelMedalInfoDTO>> equityMedalMap = equityLevelMedalList.stream().collect(Collectors.groupingBy(UserEquityLevelMedalInfoDTO::getUserId));
            //得到用户标签map
            Map<Long, List<UserTag>> userTagMap = userTagService.getBatchUserTag(userIdList);

            //得到用户帖子图片map
            AtomicReference<Map<Long, List<ImgDTO>>> imgMap = new AtomicReference<>(Maps.newHashMap());
            //得到用户纸条map
            AtomicReference<Map<Long, NoteDTO>> noteMap = new AtomicReference<>(Maps.newHashMap());

            //异步获取数据
            asyncFillContent(imgMap, noteMap, userIdList, param.getUserId());

            list.forEach(recommendFollowUsersVo -> {
                Optional<UserCacheInfoBO> optional = userInfoList.stream()
                        .filter(user -> user.getUserId().equals(recommendFollowUsersVo.getUserId()))
                        .findFirst();
                if (optional.isPresent()) {
                    UserCacheInfoBO userInfo = optional.get();
                    recommendFollowUsersVo.setNickname(userInfo.getNickname());
                    recommendFollowUsersVo.setHeadImg(Objects.nonNull(userInfo.getHeadImg()) ? userInfo.getHeadImg() : null);
                    recommendFollowUsersVo.setSex(userInfo.getSex());
                    recommendFollowUsersVo.setDesc((Objects.nonNull(userInfo.getUserInformationBO().getPersonalProfile()) && !userInfo.getUserInformationBO().getPersonalProfile().startsWith("一句话介绍下自己"))
                            ? "关于TA:" + userInfo.getUserInformationBO().getPersonalProfile()
                            : (Objects.nonNull(noteMap.get().get(recommendFollowUsersVo.getUserId())) && Objects.nonNull(noteMap.get().get(recommendFollowUsersVo.getUserId()).getTextField()))
                            ? "关于TA:" + noteMap.get().get(recommendFollowUsersVo.getUserId()).getTextField() : null);
                    recommendFollowUsersVo.setFollowed(userFollowService.isFollowed(param.getUserId(), recommendFollowUsersVo.getUserId()) ? 1 : 0);

                    //星座 年龄段计算
                    if (Objects.nonNull(userInfo.getUserInformationBO().getBirthday())) {
                        LocalDate birthday = userInfo.getUserInformationBO().
                                getBirthday().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        recommendFollowUsersVo.setConstellation(ConstellationUtils.calculateConstellation(birthday));
                        recommendFollowUsersVo.setGeneration(nativeUserService.getGeneration(userInfo.getUserInformationBO().getBirthday()));
                    }

                    //组装帖子图片
                    List<ImgDTO> imgList = imgMap.get().get(recommendFollowUsersVo.getUserId());
                    if (!CollectionUtils.isEmpty(imgList)) {
                        recommendFollowUsersVo.setImgInfo(imgList.size() > 3 ? imgList.subList(0, 3) : imgList);
                    }

                    //标签组装
                    List<String> userLabels = new ArrayList<>();
                    List<UserTag> userTagList = userTagMap.get(recommendFollowUsersVo.getUserId());
                    if (!CollectionUtils.isEmpty(userTagList)) {
                        userLabels = userTagList.stream().filter(t -> t.getDeleteFlag() == 0).map(UserTag::getLabel)
                                .collect(Collectors.toList());
                    }
                    recommendFollowUsersVo.setUserLabels(userLabels);

                    //等级勋章设置
                    List<UserEquityLevelMedalInfoDTO> userEquityLevelMedalInfoDTOS = equityMedalMap.get(recommendFollowUsersVo.getUserId());
                    if (!CollectionUtils.isEmpty(userEquityLevelMedalInfoDTOS)) {
                        UserEquityLevelMedalInfoDTO userEquityLevelMedalInfoDTO = userEquityLevelMedalInfoDTOS.get(0);
                        recommendFollowUsersVo.setUserWarmLevelDTO(userEquityLevelMedalInfoDTO.getUserEquityDTO());
                    }
                }
            });
            //做一次过滤
            list = list.stream().filter(recommendFollowUsersVo ->
                    !CollectionUtils.isEmpty(recommendFollowUsersVo.getImgInfo()) && recommendFollowUsersVo.getImgInfo().size() >= 3)
                    .collect(Collectors.toList());
        }
        return list;
    }

    /**
     * 异步线程组装基础数据
     */
    private void asyncFillContent(AtomicReference<Map<Long, List<ImgDTO>>> imgMap,
                                  AtomicReference<Map<Long, NoteDTO>> noteMap, List<Long> userIdList, Long currentUserId) {

        CompletableFuture<Map<Long, List<ImgDTO>>> img = CompletableFuture.supplyAsync(() -> {
            imgMap.set(userNewsIntegrationService.batchGetAllUserImg(userIdList, currentUserId));
            return imgMap.get();
        }).whenCompleteAsync((t, u) -> {
            if (Objects.nonNull(u)) {
                log.error("异步获取用户帖子图片集合失败 error : {}", u);
            }
            log.info("异步获取帖子图片集合完成。。");
        });
        //阻塞
        CompletableFuture<Void> all = CompletableFuture.allOf(img);
        try {
            all.get();
        } catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
        }
    }

}